# mmax {#mmax}

## Syntax {#syntax}

`mmax(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving maximums of *X* in a sliding window.

## Examples {#examples}

```
X = 2 1 3 7 6 5 4
Y = 2 1 3 NULL 6 5 4

mmax(X, 3);
// output: [,,3,7,7,7,6]

mmax(Y, 3);
// output: [,,3,3,6,6,6]

mmax(Y, 3, minPeriods=1);
// output: [2,2,3,3,6,6,6]
```

```
m = matrix(1 5 9 0 2, 9 10 2 NULL 2)
m.rename!(date(2020.09.08)+1..5, `A`B)
m.setIndexedMatrix!()
m.mmax(3d)
```

|label|col1|col2|
|-----|----|----|
|2020.09.09|1|9|
|2020.09.10|5|10|
|2020.09.11|9|10|
|2020.09.12|9|10|
|2020.09.13|9|2|

```
m.mmax(1w)
```

|label|col1|col2|
|-----|----|----|
|2020.09.09|1|9|
|2020.09.10|5|10|
|2020.09.11|9|10|
|2020.09.12|9|10|
|2020.09.13|9|10|

Related functions: [max](max.md)

