# mmad {#mmad}

## Syntax {#syntax}

`mmad(X, window, [useMedian=false], [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Arguments {#arguments}

**useMedian** is a Boolean value. The default value is false and it returns the mean absolute deviation, otherwise returns the median absolute deviation.

-   mean absolute deviation: mean\(abs\(X - mean\(X\)\)\)

-   median absolute deviation: med\(abs\(X - med\(X\)\)\)


## Details {#details}

Calculate the average absolute deviation of *X* in a sliding window.

## Examples {#examples}

```
x = 7 4 6 0 -5 32;
mmad(x, window=3);
// output: [,,1.11,2.22,3.78,15.33]

mmad(x, window=3, useMedian=true)
// output: [,,1,2,5,5]

y = NULL NULL 2 5 1 7 -3 0
mmad(y, window=3, minPeriods=2);
// output: [,,,1.5,1.56,2.22,3.56,3.78]
```

```
m=matrix(85 90 95, 185 190 195);
m;
```

|\#0|\#1|
|---|---|
|85|185|
|90|190|
|95|195|

```
mmad(m, 2)
```

|\#0|\#1|
|---|---|
|||
|2.5|2.5|
|2.5|2.5|

Related function: [mad](mad.md)

