# mlastNot {#mlastNot}

## Syntax {#Syntax .section}

`mlastNot(X, window, [k=NULL], [minPeriods=1])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Arguments {#Arguments .section}

**k** \(optional\) is a numeric or string scalar indicating the value to be matched.

## Details {#Details .section}

If *X* is a vector:

-   If *k* is not specified, return the last element of *X* that is not null in a sliding window.

-   If *k* is specified, return the last element of *X* that is neither *k* nor null in the window.


If *X* is a matrix or table, conduct the aforementioned calculation within each column of *X*. The result is a matrix or table.

## Examples {#Examples .section}

``` {#codeblock_zqc_dcd_jbc}
mlastNot(NULL 2 NULL 4 5, 2)
// output: [,2,2,4,5]
```

``` {#codeblock_utp_dcd_jbc}
mlastNot(X=matrix(1..5,2..6,3..7), window=2, k=4, minPeriods=2)
```

<table id="table_fct_wcd_jbc"><thead><tr><th>

\#0

</th><th>

\#1

</th><th>

\#2

</th></tr></thead><tbody><tr><td>



</td><td>

 

</td><td>

 

</td></tr><tr><td>

2

</td><td>

3

</td><td>

3

</td></tr><tr><td>

3

</td><td>

3

</td><td>

5

</td></tr><tr><td>

3

</td><td>

5

</td><td>

6

</td></tr><tr><td>

5

</td><td>

6

</td><td>

7

</td></tr></tbody>
</table>``` {#codeblock_emg_5bd_jbc}
x=table(["s1", "s2", "", "s4", "s5"] as col1, ["s1", "", "s3", "", "s5"] as col2)
mlastNot(X=x, window=2)
```

<table id="table_twv_xcd_jbc"><thead><tr><th>

\#0

</th><th>

\#1

</th></tr></thead><tbody><tr><td>



</td><td>

 

</td></tr><tr><td>

s2

</td><td>

s1

</td></tr><tr><td>

s2

</td><td>

s3

</td></tr><tr><td>

s4

</td><td>

s3

</td></tr><tr><td>

s5

</td><td>

s5

</td></tr></tbody>
</table>``` {#codeblock_img_5bd_jbc}
T = [2022.01.01, 2022.01.02, 2022.01.03, 2022.01.06, 2022.01.07, 2022.01.08, 2022.01.10, 2022.01.11]
X = 1..8
X1 = indexedSeries(T, X)
mlastNot(X=X1, window=3, k=1, minPeriods=1)
```

<table id="table_jmg_5bd_jbc"><tbody><tr><td>



</td><td>

\#0

</td></tr><tr><td>

2022.01.01

</td><td>

 

</td></tr><tr><td>

2022.01.02

</td><td>

2

</td></tr><tr><td>

2022.01.03

</td><td>

2

</td></tr><tr><td>

2022.01.06

</td><td>

4

</td></tr><tr><td>

2022.01.07

</td><td>

4

</td></tr><tr><td>

2022.01.08

</td><td>

4

</td></tr><tr><td>

2022.01.10

</td><td>

6

</td></tr><tr><td>

2022.01.11

</td><td>

7

</td></tr></tbody>
</table>Related functions: [mlast](mlast.md), [mfirstNot](mfirstNot.md)

