# mlast {#mlast}

## Syntax {#syntax}

`mlast(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Return the last element of *X* in a sliding window.

## Examples {#examples}

```
index = second(08:20:00)+1..7
x = 2 1 3 NULL 6 5 4
x = index.indexedSeries(x)
mlast(x,3s)
```

|label|col1|
|-----|----|
|08:20:01|2|
|08:20:02|1|
|08:20:03|3|
|08:20:04||
|08:20:05|6|
|08:20:06|5|
|08:20:07|4|

```
m = matrix(1 5 9 0 2, 9 10 2 NULL 2)
m.rename!((date(2020.09.08)+1..3) join 2020.09.16 join 2020.09.26, `A`B)
m.setIndexedMatrix!()
mlast(m, 3d)
```

|label|A|B|
|-----|---|---|
|2020.09.09|1|9|
|2020.09.10|5|10|
|2020.09.11|9|2|
|2020.09.16|0||
|2020.09.26|2|2|

```
mlast(m, 1w)
```

|label|A|B|
|-----|---|---|
|2020.09.09|1|9|
|2020.09.10|5|10|
|2020.09.11|9|2|
|2020.09.16|0||
|2020.09.26|2|2|

Related functions: [last](../l/last.md), [first](../f/first.md)

