# mkurtosis {#mkurtosis}

## Syntax {#syntax}

`mkurtosis(X, window, [biased=true], [minPeriods])`

## Arguments {#arguments}

**biased** is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving kurtosis of *X* in a sliding window.

## Examples {#examples}

```
m=matrix(1 9 3 100 3 2 1 -100 9 10000, 1 2 3 4 5 6 7 8 9 100);
m.mkurtosis(8);
```

|\#0|\#1|
|---|---|
|||
|||
|||
|||
|||
|||
|||
|3.989653641279048|1.761904761904762|
|3.989840910744778|1.761904761904762|
|6.140237905908072|6.101712240467206|

```
m.rename!(date(2020.04.06)+1..10, `col1`col2)
m.setIndexedMatrix!()
mkurtosis(m, 8d)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|||
|2020.04.08|||
|2020.04.09|1.5|1.5|
|2020.04.10|2.3195|1.64|
|2020.04.11|3.2251|1.7|
|2020.04.12|4.163|1.7314|
|2020.04.13|5.1141|1.75|
|2020.04.14|3.9897|1.7619|
|2020.04.15|3.9898|1.7619|
|2020.04.16|6.1402|6.1017|

```
mkurtosis(m, 1w)
```

|label|col1|col2|
|-----|----|----|
|2020.04.07|||
|2020.04.08|||
|2020.04.09|1.5|1.5|
|2020.04.10|2.3195|1.64|
|2020.04.11|3.2251|1.7|
|2020.04.12|4.163|1.7314|
|2020.04.13|5.1141|1.75|
|2020.04.14|3.4937|1.75|
|2020.04.15|3.4937|1.75|
|2020.04.16|5.1645|5.145|

The default case of kurtosis in DolphinDB is biased \(*biased* = true\), while in pandas and Excel it is unbiased estimation, and the kurtosis value 3 of the normal distribution is subtracted.

The following example illustrates the equivalent conversion between the two when using a sliding window:

```
// python
m = [[1111,2], [323,9], [43,12], [51,32], [6,400]]
df = pandas.DataFrame(m)
y = df.rolling(4).kurt()

// dolphindb
m=matrix(1111 323 43 51 6, 2 9 12 32 400)
m.mkurtosis(4, false)-3
```

|\#0|\#1|
|---|---|
|||
|||
|||
|2.504252|2.366838|
|3.675552|3.941262|

Related function: [kurtosis](../k/kurtosis.md)

