# min {#min}

## Syntax {#syntax}

`min(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

**Y** is an optional parameter, which can be a scalar, a vector of the same length as X or a matrix.

## Details {#details}

For one input \(null values will not be compared with other elements\):

-   If *X* is a vector, return the minimum in *X*.

-   If *X* is a matrix, return the minimum in each column of *X* and return a vector.

-   If *X* is a table, return the minimum in each column of *X* and return a table.


For two inputs \(null values will be compared with other elements\):

-   If *Y* is a scalar, compare it with each element in *X*, replace the element in *X* with the smaller value.

-   If *Y* and *X* are of the same type and length, compare the corresponding elements of them and return a vector containing each smaller value.


**Note:**

Before version 1.30.20/2.00.8, the function `min` compares the values of temporal types by converting them into LONG values. Since version 1.30.20/2.00.8, DolphinDB has changed the handling of temporal types:

-   If *X* and *Y* are temporal scalars with different levels of time granularity, the coarser-grained value is converted to the finer granularity for comparison.

-   If *X* and/or *Y* is a vector, matrix, or table, the compared elements must be of the same temporal type.


## Examples {#examples}

```
min(1 2 3);
// output: 1

min(2.0 1.1 0.1 NULL);
// output: 0.1

m=matrix(1 2 3, 4 5 6);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
min(m);
// output: [1,4]
```

```
min(1 2 3, 2)
// output: 1 2 2

n = matrix(1 1 1, 5 5 5)
n;
```

|\#0|\#1|
|---|---|
|1|5|
|1|5|
|1|5|

```
min(m, n);
```

|\#0|\#1|
|---|---|
|1|4|
|1|5|
|1|5|

Related function: [mmin](mmin.md)

