# mimax {#mimax}

## Syntax {#syntax}

`mimax(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Return the position of the element with the largest value in *X* in a sliding window. If there are multiple elements with the identical largest value in a window, return the position of the first element from the left. Same as other aggregate functions, null values are ignored.

## Examples {#examples}

```
x = 1.2 2 NULL 6 -1 6
mimax(x, 3);
// output: [,,1,2,1,0]

mimax(x, 3, 1);
// output: [0,1,1,2,1,0]
```

``` {#codeblock_sdw_2nh_3bc}
m=matrix(1 6 2 9 10 3, 9 10 2 6 6 6);
m;
```

|\#0|\#1|
|---|---|
|1|9|
|6|10|
|2|2|
|9|6|
|10|6|
|3|6|

```
mimax(m,3);
```

|\#0|\#1|
|---|---|
|||
|||
|1|1|
|2|0|
|2|1|
|1|0|

``` {#codeblock_b5c_qv5_x1c}
T = [2022.01.01, 2022.01.02, 2022.01.03, 2022.01.06, 2022.01.07, 2022.01.08, 2022.01.10, 2022.01.11]
X = 1..8
X1 = indexedSeries(T, X)
mimax(X1,3)
```

| |\#0|
|---|---|
|2022.01.01|0|
|2022.01.02|1|
|2022.01.03|2|
|2022.01.06|0|
|2022.01.07|1|
|2022.01.08|2|
|2022.01.10|1|
|2022.01.11|1|

``` {#codeblock_dy5_qv5_x1c}
t= 2021.01.02 2021.01.05  2021.01.06  2021.01.09 2021.01.10 2021.01.12
m=matrix(5 4 NULL -1 2 4, 3 2 8 1 0 5)
m1=m.rename!(t, `a`b).setIndexedMatrix!()
mimax(m1,3)
```

| |a|b|
|---|---|---|
|2021.01.02|0|0|
|2021.01.05|0|0|
|2021.01.06|0|1|
|2021.01.09|0|0|
|2021.01.10|1|0|
|2021.01.12|1|1|

Related functions: [imax](../i/imax.md), [mimin](mimin.md)

