# mfirstNot {#mfirstNot}

## Syntax {#Syntax .section}

`mfirstNot(X, window, [k=NULL], [minPeriods=1])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Arguments {#Arguments .section}

**k** \(optional\) is a numeric or string scalar indicating the value to be matched.

## Details {#Details .section}

If *X* is a vector:

-   If *k* is not specified, return the first element of *X* that is not null in a sliding window.

-   If *k* is specified, return the first element of *X* that is neither *k* nor null in the window.


If *X* is a matrix or table, conduct the aforementioned calculation within each column of *X*. The result is a vector.

## Examples {#Examples .section}

``` {#codeblock_zqc_dcd_jbc}
mfirstNot(NULL 2 NULL 4 5, window=2)
// output: [,2,2,4,4]
```

``` {#codeblock_utp_dcd_jbc}
x = matrix(1..5,2..6,3..7)
mfirstNot(X=x, window=3, k=1, minPeriods=2)
```

<table id="table_amg_5bd_jbc"><thead><tr><th>

\#0

</th><th>

\#1

</th><th>

\#2

</th></tr></thead><tbody><tr><td>



</td><td>



</td><td>



</td></tr><tr><td>

2

</td><td>

2

</td><td>

3

</td></tr><tr><td>

2

</td><td>

2

</td><td>

3

</td></tr><tr><td>

2

</td><td>

3

</td><td>

4

</td></tr><tr><td>

3

</td><td>

4

</td><td>

5

</td></tr></tbody>
</table>``` {#codeblock_emg_5bd_jbc}
x=table(["s1", "s2", "", "s4", "s5"] as col1, ["s1", "", "s3", "", "s5"] as col2)
mfirstNot(X=x, window=2)
```

<table id="table_fmg_5bd_jbc"><thead><tr><th>

\#0

</th><th>

\#1

</th></tr></thead><tbody><tr><td>



</td><td>



</td></tr><tr><td>

s1

</td><td>

s1

</td></tr><tr><td>

s2

</td><td>

s3

</td></tr><tr><td>

s4

</td><td>

s3

</td></tr><tr><td>

s4

</td><td>

s5

</td></tr></tbody>
</table>``` {#codeblock_img_5bd_jbc}
T = [2022.01.01, 2022.01.02, 2022.01.03, 2022.01.06, 2022.01.07, 2022.01.08, 2022.01.10, 2022.01.11]
X = 1..8
X1 = indexedSeries(T, X)
mfirstNot(X=X1, window=3, k=1, minPeriods=1)
```

||\#0|
|---|---|
|2022.01.01| |
|2022.01.02|2|
|2022.01.03|2|
|2022.01.06|4|
|2022.01.07|4|
|2022.01.08|4|
|2022.01.10|6|
|2022.01.11|7|

Related function: [mfirst](mfirst.md), [mlastNot](mlastNot.md)

