# mfirst {#mfirst}

## Syntax {#syntax}

`mfirst(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Return the first element of *X* in a sliding window.

## Examples {#examples}

```
index = second(08:20:00)+1..7
x = 2 1 3 NULL 6 5 4
x = index.indexedSeries(x)
mfirst(x,3s)
```

|label|col1|
|-----|----|
|08:20:01|2|
|08:20:02|2|
|08:20:03|2|
|08:20:04|1|
|08:20:05|3|
|08:20:06||
|08:20:07|6|

```
m = matrix(1 5 9 0 2, 9 10 2 NULL 2)
m.rename!((date(2020.09.08)+1..3) join 2020.09.16 join 2020.09.26, `A`B)
m.setIndexedMatrix!()
mfirst(m, 3d)
```

|label|A|B|
|-----|---|---|
|2020.09.09|1|9|
|2020.09.10|1|9|
|2020.09.11|1|9|
|2020.09.16|0||
|2020.09.26|2|2|

```
mfirst(m, 1w)
```

|label|A|B|
|-----|---|---|
|2020.09.09|1|9|
|2020.09.10|1|9|
|2020.09.11|1|9|
|2020.09.16|5|10|
|2020.09.26|2|2|

Related functions: [first](../f/first.md), [last](../l/last.md)

