# memSize {#memsize}

## Syntax {#syntax}

`memSize(obj)`

## Arguments {#arguments}

**obj** is an object.

## Details {#details}

Return the memory usage \(in units of bytes\) of a local or shared object.

## Examples {#examples}

```
n=100
ID=rand(100, n)
date=rand(2017.08.07..2017.08.11, n)
x=rand(10.0, n)
t=table(ID, date, x);
share t as tt
memSize(t)
// output: 1952

memSize(tt)
// output: 1952

memSize(t[`x])
// output: 800

memSize(select avg(x) as avgx from t)
// output: 280
```

Related functions: [objs](../o/objs.md)

