# mem {#mem}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`mem([freeUnusedBlocks=false])`

## Arguments {#arguments}

**freeUnusedBlocks** is a Boolean value indicating whether to free unused memory blocks. The default value is false.

## Details {#details}

Display the memory usage of the current node. If *freeUnusedBlocks*=true, free unused memory blocks.

## Examples {#examples}

```
undef all;
t1=table(1 2 3 as a, `x`y`z as b, 10.8 7.6 3.5 as c)
mem();
```

|blockSize|freeSize|freeBlock|leafSize|
|---------|--------|---------|--------|
|37748736|37616400|15|144|
|67108864|66494464|8117|8192|

```
x=bigarray(int,100000,10000000)
mem();
```

|blockSize|freeSize|freeBlock|leafSize|
|---------|--------|---------|--------|
|536879104|532684736|7|1048592|
|37748736|37618848|13|144|
|67108864|66994176|8178|8192|

```
undef all;
mem();
```

|blockSize|freeSize|freeBlock|leafSize|
|---------|--------|---------|--------|
|37748736|37619424|14|144|
|67108864|66994176|8178|8192|

