# mcovarTopN {#mcovartopn}

## Syntax {#syntax}

`mcovarTopN(X, Y, S, window, top, [ascending=true], [tiesMethod='oldest'])`

Please see [mTopN](../Themes/mTopN.md) for the parameters and windowing logic.

## Details {#details}

Within a sliding window of given length \(measured by the number of elements\), the function stably sorts *X* and *Y* by *S* in the order specified by *ascending*, then calculates the moving covariance of the first *top* pairs of elements in *X* and *Y*.

## Examples {#examples}

```
x = NULL 3 8 4 0
y = 2 3 1 7 3
s = 5 NULL 8 9 4

mcovarTopN(x, y, s, 3, 2)
// output: [ , , , -12, -8]

s2=2021.01.01 2021.02.03 2021.01.23 2021.04.06 2021.12.29
mcovarTopN(x, y, s2, 3, 2)
// output: [ , , , -5, -12]

x1 = matrix(x, 4 3 6 2 3)
y1=matrix(3 7 9 3 2, y)
s1=matrix(2 3 1 7 3, s)

mcovarTopN(x, y1, s1, 3, 2)
```

|col1|col2|
|----|----|
|||
|||
|||
|5|-5|
|28|-8|

```
mcovarTopN(x1, y1, s, 3, 2)
```

|col1|col2|
|----|----|
|||
||-0.5|
||-0.5|
|5|-3|
|28|-3|

```
mcovarTopN(x1, y1, s1, 3, 2)
```

|col1|col2|
|----|----|
|||
||-0.5|
||-0.5|
|5|-3|
|28|-3|

```
n = 3000
ids = 1..3000
dates = take(2021.01.01..2021.10.01,n)
prices = rand(1000,n)
vals = rand(1000,n)
t = table(ids as id,dates as date,prices as price,vals as val)
dbName = "dfs://test_mcovarTopN_2"
if(existsDatabase(dbName))dropDB(dbName)
db = database(dbName,VALUE,1..5000)
pt = db.createPartitionedTable(t,"pt",`id).append!(t)
select mcovarTopN(price, val, id, 10, 5, true) from pt where date>2021.05.01
```

Related function: [mcovar](mcovar.md)

