# mcovar {#mcovar}

## Syntax {#syntax}

`mcovar(X, Y, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the moving covariance of *X* and *Y* in a sliding window.

## Examples {#examples}

```
x=1..10;
y=9 5 3 4 5 4 7 1 3 4;
mcovar(x,y,5);
// output: [,,,,-2.25,0,2,-1,-1.75,-1]

mcovar(x, y, 5, 3);
// output: [,,-3,-2.833333,-2.25,0,2,-1,-1.75,-1]

x1 = indexedSeries(date(2020.06.05)+1..10, x)
y1 = indexedSeries(date(2020.06.05)+1..10, y)
mcovar(x1,y1,5d)
```

|label|col1|
|-----|----|
|2020.06.06||
|2020.06.07|-2|
|2020.06.08|-3|
|2020.06.09|-2.8333|
|2020.06.10|-2.25|
|2020.06.11|0|
|2020.06.12|2|
|2020.06.13|-1|
|2020.06.14|-1.75|
|2020.06.15|-1|

```
mcovar(x1,y1,1w)
```

|label|col1|
|-----|----|
|2020.06.06||
|2020.06.07|-2|
|2020.06.08|-3|
|2020.06.09|-2.8333|
|2020.06.10|-2.25|
|2020.06.11|-2.4|
|2020.06.12|-1|
|2020.06.13|-0.6667|
|2020.06.14|-0.6667|
|2020.06.15|-1.6667|

Related functions: [covar](../c/covar.md), [mcorr](mcorr.md), [mstd](mstd.md), [mvar](mvar.md)

