# mcorr {#mcorr}

## Syntax {#syntax}

`mcorr(X, Y, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#details}

Calculate the correlation of *X* and *Y* in a sliding window.

## Examples {#examples}

```
x=1..8
y=9 5 3 4 5 4 7 1
mcorr(x,y,5);
// output: [,,,,-0.624038,0,0.834058,-0.29173]

mcorr(x,y,5,3);
// output: [,,-0.981981,-0.834497,-0.624038,0,0.834058,-0.29173]

x1 = indexedSeries(date(2020.06.05)+1..8, x)
y1 = indexedSeries(date(2020.06.05)+1..6 join 2020.06.15 join 2020.06.16, y)
mcorr(x1,y1,5d)
```

|label|col1|
|-----|----|
|2020.06.06||
|2020.06.07|-1|
|2020.06.08|-0.982|
|2020.06.09|-0.8345|
|2020.06.10|-0.624|
|2020.06.11|0|
|2020.06.12|0.6325|
|2020.06.13|0|

```
mcorr(x1,y1,1w)
```

|label|col1|
|-----|----|
|2020.06.06||
|2020.06.07|-1|
|2020.06.08|-0.982|
|2020.06.09|-0.8345|
|2020.06.10|-0.624|
|2020.06.11|-0.6116|
|2020.06.12|-0.6116|
|2020.06.13|0|

Related functions: [corr](../c/corr.md), [mmin](mmin.md), [mmax](mmax.md), [mavg](mavg.md), [msum](msum.md), [mstd](mstd.md), [mvar](mvar.md)

