# maxDrawdown {#maxDrawdown}

## Syntax {#Syntax .section}

`maxDrawdown(X, [ratio=true])`

## Arguments {#Arguments .section}

**X** is a numeric vector, indicating the input data for calculating maximum drawdown \(MDD\), commonly cumulative return \(or rate\).

**ratio** \(optional\) is a Boolean scalar indicating whether to express the MDD in ratio or absolute value.

-   true \(default\): Return the ratio of MDD over the peak.

    ![](../../images/mdd1.png)

-   false: Return the absolute value of MDD.

    ![](../../images/mdd2.png)


## Details {#Details .section}

Calculate the maximum drawdown for the input *X*. Null values are ignored in calculation.

**Return value**: A scalar of the same type as *X*.

## Examples {#Examples .section}

Suppose the daily returns for a portfolio are as follows:

|Date|Returns|
|----|-------|
|2024-10-01|36|
|2024-10-02|96|
|2024-10-03|42|
|2024-10-04|100|
|2024-10-05|59|
|2024-10-06|86|
|2024-10-07|25|
|2024-10-08|72|

Calculate the maximum drawdown:

``` {#codeblock_jyf_tnv_ddc}
x = [36,96,42,100,59,86,25,64,72]

maxDrawdown(x)
// output: 0.75
maxDrawdown(x, false)
// output: 75
```

**Parent topic:**[Functions](../../Functions/category.md)

