# max {#max}

## Syntax {#syntax}

`max(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

**Y** \(optional\) is a scalar, a vector of the same length as *X* or a matrix.

## Details {#details}

For one input:

-   If *X* is a vector, return the maximum in *X*.

-   If *X* is a matrix, return a vector composed of the maximum in each column of *X*.

-   If *X* is a table, return a table composed of the maximum in each column of *X*.


For two inputs:

-   If *Y* is a scalar, compare it with each element in *X*, replace the element in *X* with the larger value.

-   If *Y* and *X* are of the same type and length, compare the corresponding elements of them and return a result containing each larger value.


**Note:**

Before version 1.30.20/2.00.8, the function `max` compares the values of temporal types by converting them into LONG values;

Since version 1.30.20/2.00.8, DolphinDB has changed the handling of temporal types:

-   If *X* and *Y* are temporal scalars with different levels of time granularity, the coarser-grained value is converted to the finer granularity for comparison.

-   If *X* and/or *Y* is a vector, matrix, or table, the compared elements must be of the same temporal type.


## Examples {#examples}

```
max(1 2 3);
// output: 3

max(7.8 9 5.4);
// output: 9

(5 8 2 7).max();
// output: 8

m=matrix(1 2 3, 4 5 6);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|2|5|
|3|6|

```
max(m);
// output: [3,6]
```

```
max(1 2 3, 2)
// output: 2 2 3

n = matrix(1 1 1, 5 5 5)
n;
```

|\#0|\#1|
|---|---|
|1|5|
|1|5|
|1|5|

```
max(m, n);
```

|\#0|\#1|
|---|---|
|1|5|
|2|5|
|3|6|

Use with SQL SELECT to return the maximum value of a column:

``` {#codeblock_s4h_b3z_hzb}
t = table(`abb`aac`aaa as sym, 1.8 2.3 3.7 as price);
select max price from t;
```

|max\_price|
|----------|
|3.7|

`max` can be applied to strings to return the lexicographically largest string:

``` {#codeblock_lbd_w3z_hzb}
select max sym from t;
```

|max\_sym|
|--------|
|abb|

Related function: [mmax](mmax.md)

