# matrixRank {#matrixRank}

## Syntax {#Syntax .section}

`matrixRank(A, [tol])`

## Arguments {#Arguments .section}

**A**is a numeric matrix. One-dimensional matrices can be represented by vectors.

**tol** is a numeric scalar. Singular values less than *tol*will be treated as zero, so the rank of the matrix will be the number of singular values greater than *tol*. The default value is the minimum precision of double precision floating-point numbers, DBL\_EPSILON = 2.22044604925e-16.

## Details {#Details .section}

Calculate the rank of matrix.

## Examples {#Examples .section}

``` {#codeblock_apv_45w_z1c}
m1 = matrix(1..4,1..4*2,3..6)
matrixRank(m1) 
// output: 2
```



**Parent topic:**[Functions](../../Functions/category.md)

