# manova {#manova}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`manova(X, group)`

## Arguments {#arguments}

**X** is a matrix or a table whose columns are all of numeric types.

**group** is a vector with the same length as each of the columns of *X* indicating groups.

## Details {#details}

Conduct multivariate analysis of variance \(MANOVA\).

## Examples {#examples}

```
a=29.6 24.3 1.5 20.2 2.6 44.5 2.4 20 9.5
b=27.3 68.4 3.8 34.8 4.6 26.3 5.9 20 5.6
c=50.8 60.2 1.0 30.1 2.1 27.9 2.3 20 8.8
g=1 1 2 1 2 1 2 1 2
t=table(a,b,c,g)
manova(select a,b,c from t, t.g);

/* output:
dfT->8
dfB->1
gnames->[1,2]
gmdist->
#0        #1
--------- ---------
0         16.458055
16.458055 0

mdist->[5.35501,5.171516,0.132336,1.335303,0.043425,5.384036,0.07295,2.844008,0.661416]
chisq->[10.056959]
B->
#0          #1          #2
----------- ----------- -----------
1250.307556 1601.627111 1805.355556
1601.627111 2051.662722 2312.636111
1805.355556 2312.636111 2606.805556

lambda->[0.160648]
W->
#0       #1        #2
-------- --------- --------
453.968  -151.966  16.31
-151.966 1477.6995 1008.395
16.31    1008.395  1182.63

T->
#0          #1          #2
----------- ----------- -----------
1704.275556 1449.661111 1821.665556
1449.661111 3529.362222 3321.031111
1821.665556 3321.031111 3789.435556

chisqdf->[3]
P->[0.018088]
dfW->7
eigenval->[5.224779,2.757998E-16,-1.552556E-15]
eigenvec->
#0       #1        #2
-------- --------- ---------
0.099362 0.08179   0.023313
0.029973 -0.010892 0.107448
0.023044 -0.046981 -0.111469

canon->
#0        #1        #2
--------- --------- ---------
2.047837  -0.369203 -2.271294
2.969714  -1.691977 0.973456
-2.596193 -0.071875 0.09971
0.861618  -0.247207 0.622822
-2.437568 -0.042299 0.088698
2.970655  1.936238  0.521256
-2.413867 -0.082213 0.201424
0.165404  0.372149  0.153761
-1.567601 0.196387  -0.389832
*/
```

