# mannWhitneyUTest {#mannwhitneyutest}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`mannWhitneyUTest(X, Y, [correct=true])`

## Arguments {#arguments}

**X** is a numeric vector.

**Y** is a numeric vector.

**correct** is a Boolean value indicating whether to consider continuity correction when calculating the p-value. The default value is true.

## Details {#details}

Perform the Mann-Whitney U test on *X* and *Y*. It returns a dictionary object with the following keys:

-   stat: A table containing p-values under three different alternative hypotheses

-   correct: Whether to consider continuity correction when calculating p-value

-   method: The string "Mann-Whitney U test"

-   U: U statistic


## Examples {#examples}

```
mannWhitneyUTest(5 1 4 3 5, 2 4 7 -1 0 4);

/* output:
stat->

alternativeHypothesis                 pValue
------------------------------------- --------
true location shift is not equal to 0 0.518023
true location shift is less than 0    0.259011
true location shift is greater than 0 0.797036

correct->true
method->Mann-Whitney U test
U->11
*/
```

