# makeUnifiedCall {#topic_fcy_xvc_s1c}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#topic_gcy_xvc_s1c}

`makeUnifiedCall(func, args)`

## Arguments {#topic_hcy_xvc_s1c}

**func** is a function.

**args** is a tuple. Each element is a parameter of *func*. Since version 2.00.11.3, *args* can be metacode with a tuple expression.

## Details {#topic_icy_xvc_s1c}

Generate metacode for function call. Use function [eval](../e/eval.md) to execute the metacode. The difference between `makeUnifiedCall` and the template function [unifiedCall](../Templates/unifiedCall.md) is that `makeUnifiedCall` doesn't execute the metacode.

## Examples {#topic_jcy_xvc_s1c}

``` {#codeblock_kcy_xvc_s1c}
mc = makeUnifiedCall(matrix, (1 2 3, 4 5 6));
mc;
// output: < matrix([1,2,3], [4,5,6]) >

mc.eval();
```

|col1|col2|
|----|----|
|1|4|
|2|5|
|3|6|

Since version 2.00.11.3, *args* can be tuple metacode to be dynamically passed to a function. The following example illustrates the difference between passing *args* as a tuple and tuple metacode.

``` {#codeblock_jsp_1wc_s1c}
x=3
y=5
a = makeUnifiedCall(add, (x,y)) // < add(3, 5) >
b = makeUnifiedCall(add, <(x,y)>) // < add(x, y) >
```

-   If *args* is a tuple, `makeUnifiedCall` passes the values of the variables in the tuple to *func* and generates `< add(3, 5) >`.

-   If *args* is metacode with a tuple expression, `makeUnifiedCall` passes the variables in the tuple expression to *func* and generates `< add(x, y) >`.


When the value of *x* or *y* changes, the execution result of `a` remains unchanged while that of `b` changes accordingly as it dynamically passes the values of *x* and *y*.

``` {#codeblock_amy_bwc_s1c}
x = 6
a.eval() // 3+5=8
b.eval() //  6+5=11
```

`makeUnifiedCall` can also be used with `sqlTuple` and `sql` to dynamically generate SQL metacode. In the following example, the parameter *args* of `makeUnifiedCall` is tuple metacode generated using `sqlTuple`, and *func* is a user-defined function. The result of `makeUnifiedCall` is passed as the parameter *select* of function `sql` to generate SQL metacode `c`.

``` {#codeblock_lzx_cwc_s1c}
// Create a user-defined function
f = def (x,y)->(x-y)/(x+y)

// Create a table for query
t = table(1.0 2.0 3.0 as qty1, 1.0 3.0 7.0 as qty2)

// Generate metacode for query
c = sql(select=makeUnifiedCall(f, sqlTuple(`qty1`qty2)), from=t)

// Execute the corresponding metacode
c.eval()
```

<table id="table_rg4_dwc_s1c"><thead><tr><th align="left">

**\_qty1**

</th></tr></thead><tbody><tr><td align="left">

0

</td></tr><tr><td align="left">

-0.2

</td></tr><tr><td align="left">

-0.4

</td></tr></tbody>
</table>Related Information: [sqlTuple](../s/sqlTuple.md)

