# mTopRange {#mTopRange}

## Syntax {#Syntax .section}

`mTopRange(X, window, [minPeriods])`

Please see [mFunctions](../Themes/mFunctions.md) for the parameters and windowing logic.

## Details {#Details .section}

For each element *Xi* in a sliding window of *X*, count the continuous nearest neighbors to its left that are smaller than *Xi*. Null values are treated as the minimum values.

If *X* is a matrix, conduct the aforementioned calculation within each column of *X*.

## Examples {#Examples .section}

``` {#codeblock_zqc_dcd_jbc}
x = [NULL, 3.1, NULL, 3.0, 2.9, 2.8, 3.1, NULL, 3.2]
mTopRange(x, window=3)
// output: [,,0,1,0,0,2,0,2]

mTopRange(x, window=3, minPeriods=1)
// output: [,1,0,1,0,0,2,0,2]

x = [NULL, NULL, NULL, NULL, NULL, 2, NULL, NULL, 3.2]
date = [0, 1, 2, 3, 7, 8, 9, 10, 11] + 2020.01.01
X = indexedSeries(date, x) 
mTopRange(X, 3d)
```

<table id="table_ir1_5mr_jbc"><thead><tr><th>

 

</th><th>

\#0

</th></tr></thead><tbody><tr><td>

2020.01.01

</td><td>



</td></tr><tr><td>

2020.01.02

</td><td>



</td></tr><tr><td>

2020.01.03

</td><td>



</td></tr><tr><td>

2020.01.04

</td><td>



</td></tr><tr><td>

2020.01.08

</td><td>



</td></tr><tr><td>

2020.01.09

</td><td>

1

</td></tr><tr><td>

2020.01.10

</td><td>

0

</td></tr><tr><td>

2020.01.11

</td><td>

0

</td></tr><tr><td>

2020.01.12

</td><td>

2

</td></tr></tbody>
</table>``` {#codeblock_bym_dmr_jbc}
m = matrix(1 2 3 NULL, 1 2 NULL 3, 1 3 NULL NULL, 1 2 3 4)
mTopRange(m, 2)
```

<table id="table_dyy_vmr_jbc"><thead><tr><th>

\#0

</th><th>

\#1

</th><th>

\#2

</th><th>

\#3

</th></tr></thead><tbody><tr><td>



</td><td>



</td><td>



</td><td>



</td></tr><tr><td>

1

</td><td>

1

</td><td>

1

</td><td>

1

</td></tr><tr><td>

1

</td><td>

0

</td><td>

0

</td><td>

1

</td></tr><tr><td>

0

</td><td>

1

</td><td>



</td><td>

1

</td></tr></tbody>
</table>**Parent topic:**[Functions](../../Functions/category.md)

