# lowerBound {#lowerBound}

## Syntax {#Syntax .section}

`lowerBound(X,Y)`

## Arguments {#Arguments .section}

**X** is an increasing vector, or an indexed series/matrix.

**Y** is a scalar, vector, array vector, tuple, matrix, dictionary or table.

## Details {#Details .section}

For each element y in *Y*, get the first element that is greater than or equal to y and return its index in *X*. If no element is found, return the length of *X*.

## Examples {#Examples .section}

``` {#codeblock_shn_hlc_2bc}
X = [1,3,5];
Y = [5,6,7];
Z = lowerBound(X,Y);
Z
// output: [2,3,3]

index = [2023.05.04, 2023.05.06, 2023.05.07, 2023.05.10]
s = indexedSeries(index, 1..4)
y=[2023.05.04, 2023.05.06, 2023.05.09]

lowerBound(s,y)
```

|label|\#0|
|-----|---|
|2023.05.04|1|
|2023.05.06|2|
|2023.05.09|4|

**Parent topic:**[Functions](../../Functions/category.md)

