# loc {#loc}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`loc(obj, rowFilter, [colFilter], [view=false])`

## Arguments {#arguments}

**obj** is a matrix object. It can be a standard matrix, an indexed series or an indexed matrix.

**rowFilter**/**colFilter** can be:

-   a Boolean vector - the rows/columns marked as true will be returned. The length of the vector must match the number of rows/columns of *obj*.

-   a scalar, a vector or a pair whose data type is compatible with the row/column labels of obj. A pair indicates the selection range \(both upper bound and lower bound are inclusive\).


**Note:**

-   If *rowFilter/colFilter* is a pair, then *obj* must be an indexed series or an indexed matrix.

-   Data type compatibility rules:

    -   INT, SHORT, LONG and CHAR are compatible

    -   FLOAT and DOUBLE are compatible

    -   STRING and SYMBOL are compatible


**view** is a Boolean value. The default value is false indicating the result will be a copy of the original matrix \(deep copy\). If set to true, the result will be a view on the original matrix \(shallow copy\) and changes made to the original matrix will be reflected in the view.

## Details {#details}

Access a group of rows and columns of a matrix by label\(s\) or a boolean vector. Return a copy or a view of the original matrix.

## Examples {#examples}

```
m=rand(12, 3:4)
m;
```

|col1|col2|col3|col4|
|----|----|----|----|
|3|10|6|5|
|4|11|6|0|
|7|2|1|8|

```
a = m.loc(colFilter=[true, true, true, false], view=true)
b = m.loc(colFilter=[true, true, true, false], view=false)
a;
```

|col1|col2|col3|
|----|----|----|
|3|10|6|
|4|11|6|
|7|2|1|

```
b;
```

|col1|col2|col3|
|----|----|----|
|3|10|6|
|4|11|6|
|7|2|1|

```
// a view reflects changes made to the original matrix whereas a copy doesn't
m[0,0] = -1
a;
```

|col1|col2|col3|
|----|----|----|
|-1|10|6|
|4|11|6|
|7|2|1|

```
b;
```

|col1|col2|col3|
|----|----|----|
|3|10|6|
|4|11|6|
|7|2|1|

```
m = rand(48, 6:8)
m;
```

|col1|col2|col3|col4|col5|col6|col7|col8|
|----|----|----|----|----|----|----|----|
|27|31|47|21|12|43|22|11|
|3|20|13|37|3|46|27|27|
|13|5|14|11|26|42|4|18|
|45|9|31|33|12|19|42|17|
|2|19|30|25|36|27|21|6|
|9|36|15|10|29|37|31|42|

```
// filter with Boolean values
m.loc(rowFilter=[true, true, false, false, true, false])
```

|col1|col2|col3|col4|col5|col6|col7|col8|
|----|----|----|----|----|----|----|----|
|27|31|47|21|12|43|22|11|
|3|20|13|37|3|46|27|27|
|2|19|30|25|36|27|21|6|

```
m.loc(colFilter=[true, true, false, false, true, false, false, true])
```

|col1|col2|col3|col4|
|----|----|----|----|
|27|31|12|11|
|3|20|3|27|
|13|5|26|18|
|45|9|12|17|
|2|19|36|6|
|9|36|29|42|

```
// filter with labels
m.rename!(`A`A`B`A`B`B, 2022.01.01 + 0..7)
m;
```

|label|2022.01.01|2022.01.02|2022.01.03|2022.01.04|2022.01.05|2022.01.06|2022.01.07|2022.01.08|
|-----|----------|----------|----------|----------|----------|----------|----------|----------|
|A|27|31|47|21|12|43|22|11|
|A|3|20|13|37|3|46|27|27|
|B|13|5|14|11|26|42|4|18|
|A|45|9|31|33|12|19|42|17|
|B|2|19|30|25|36|27|21|6|
|B|9|36|15|10|29|37|31|42|

```
m.loc(rowFilter=`A);
```

|label|2022.01.01|2022.01.02|2022.01.03|2022.01.04|2022.01.05|2022.01.06|2022.01.07|2022.01.08|
|-----|----------|----------|----------|----------|----------|----------|----------|----------|
|A|27|31|47|21|12|43|22|11|
|A|3|20|13|37|3|46|27|27|
|A|45|9|31|33|12|19|42|17|

```
m.loc(colFilter=2022.01.02);
```

|label|2022.01.02|
|-----|----------|
|A|31|
|A|20|
|B|5|
|A|9|
|B|19|
|B|36|

```
m.loc(rowFilter=`B, colFilter=2022.01.03)
```

|label|2022.01.03|
|-----|----------|
|B|14|
|B|30|
|B|15|

When *rowFilter* / *colFilter* is a pair, *obj* must be an indexed matrix, which can be converted using [setIndexedMatrix!](../s/setIndexedMatrix!.md).

``` {#codeblock_bkg_kf5_hzb}
m = rand(30, 5:6).rename!(1..5, 2022.01.01 + 0..5)
m.setIndexedMatrix!()
m;
```

|label|2022.01.01|2022.01.02|2022.01.03|2022.01.04|2022.01.05|2022.01.06|
|-----|----------|----------|----------|----------|----------|----------|
|1|5|27|26|18|29|3|
|2|11|12|21|15|3|3|
|3|1|23|29|17|7|18|
|4|1|6|12|27|23|23|
|5|15|7|3|19|4|8|

``` {#codeblock_imh_nf5_hzb}
m.loc(rowFilter=2:4, colFilter=2022.01.03:2022.01.06)
```

|label|2022.01.03|2022.01.04|2022.01.05|2022.01.06|
|-----|----------|----------|----------|----------|
|2|21|15|3|3|
|3|29|17|7|18|
|4|12|27|23|23|

Related function: [at](../a/at.md)

