# loadTable {#loadtable}

## Syntax {#syntax}

`loadTable(database, tableName, [partitions], [memoryMode=false])`

## Arguments {#arguments}

**database** is either a database handle, or the absolute path of the folder where the database is stored. The database can be located in the local file system, or the distributed file system.

**tableName** is a string indicating the name of the table on disk.

**partitions** is a scalar or vector indicating which partitions of the table to load into memory.

**memoryMode** is a Boolean value indicating whether to load only metadata into memory \(*memoryMode* = false\). If *memoryMode* = true, load all data or selected partitions into memory. Please note that this parameter only takes effect for local databases on disk. For DFS databases, only the metadata is loaded into memory.

## Details {#details}

For a DFS table: return a table object with only the metadata.

For a partitioned table in the local file system: if *memoryMode* = true, load all partitions \(or selected partitions if parameter *partitions* is specified\) into memory as a partitioned table; if *memoryMode* = false, only load metadata into memory.

## Examples {#examples}

In the distributed file system:

``` {#codeblock_zrw_3j1_dzb}
n=1000000
ID=rand(100, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t1=table(ID, date, x);

dbDate = database(, VALUE, 2017.08.07..2017.08.11)
dbID=database(, RANGE, 0 50 100);
db = database("dfs://compoDB", COMPO, [dbDate, dbID]);
pt = db.createPartitionedTable(t1, `pt, `date`ID).append!(t1)

t2=table(0..100 as ID,take(2017.08.07..2017.08.11,101) as date)
dt = db.createDimensionTable(t2, `dt).append!(t2)
```

-   To load a dimension table:

    ``` {#codeblock_dbr_jj1_dzb}
    tmp = loadTable("dfs://compoDB", `dt)
    select count(*) from tmp
    ```

    |count|
    |-----|
    |101|

-   To load a partitioned table:

    ``` {#codeblock_hyh_qxt_hzb}
    tmp = loadTable("dfs://compoDB", `pt)
    select count(*) from tmp
    ```

    |count|
    |-----|
    |1000000|

-   For a DFS table, we cannot use *loadTable* to load specified partitions directly. To load specified partitions into memory, we can specify the filtering conditions in the SQL statement.

    ``` {#codeblock_ons_lj1_dzb}
    tmp = loadTable("dfs://compoDB", `pt)
    select * from tmp where date=2017.08.07
    ```


With the in-memory partitioned table, we can execute functions such as [update!](../u/update!.md), [drop!](../d/dropColumns!.md), [rename!](../r/rename!.md), [sortBy!](../s/sortBy!.md) etc.

