# loadRecord {#loadrecord}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`loadRecord(filename, schema, [skipBytes=0], [count])`

## Arguments {#arguments}

**filename** is a string indicating the path of a file.

**schema** is a tuple of vectors. Each vector of the tuple represents the name and data type of a column. For a string column, we also need to specify the length of the string. If a string is shorter than the specified length, add 0s in the end to reach the specified length.

**skipBytes** is a nonnegative integer indicating the number of bytes to skip in the beginning of the file. The default value is 0.

**count** is a positive integer indicating the number of records to load. If it is not specified, load all records.

## Details {#details}

Load a binary file with fixed length for each column into memory.

## Examples {#examples}

The following is a binary file *sample.bin*:

```
/* output:
0000000 3036 3131 3737 532e 0048 0000 0000 0000
0000010 0000 0000 0000 0000 0000 0000 0000 0000
0000020 16b6 0134 d160 0578 0000 0000 0000 0000
0000030 0000 0000 3333 4137 0000 0000 0000 0000
0000040 0000 0000 0000 0000 0000 0000 0000 0000
0000050 0000 0000 0000 0000 0000 0000 00c8 0000
0000060 0000 0000 0000 0000 0000 0000 0000 0000
*
0000080 0000 0000 3333 4137 0000 0000 0000 0000
0000090 0000 0000 0000 0000 0000 0000 0000 0000
00000a0 0000 0000 0000 0000 0000 0000 00c8 0000
00000b0 0384 0000 0000 0000 0000 0000 0000 0000
00000c0 0000 0000 0000 0000 0000 0000 0000 0000
00000d0 0000 0000 3036 3131 3737 532e 0048 0000
00000e0 0000 0000 0000 0000 0000 0000 0000 0000
00000f0 0000 0000 16b6 0134 ea58 057b 0000 0000
0000100 0000 0000 0000 0000 3333 4137 0000 0000
0000110 0000 0000 0000 0000 0000 0000 0000 0000
*
0000130 00c8 0000 0000 0000 0000 0000 0000 0000
0000140 0000 0000 0000 0000 0000 0000 0000 0000
0000150 0000 0000 0000 0000 3333 4137 0000 0000
0000160 0000 0000 0000 0000 0000 0000 0000 0000
*
0000180 00c8 0000 0b54 0000 0000 0000 0000 0000
0000190 0000 0000 0000 0000 0000 0000 0000 0000
00001a0 0000 0000 0000 0000 3036 3131 3737 532e
00001b0 0048 0000 0000 0000 0000 0000 0000 0000
00001c0 0000 0000 0000 0000 16b6 0134 82b0 057c
00001d0 0000 0000 0000 0000 0000 0000 3333 4137
00001e0 0000 0000 0000 0000 0000 0000 0000 0000
*
0000200
*/
```

Use function `loadRecord` to load the file into DolphinDB. Please note that the column code ia s string with fixed length of 32 in the file.

```
schema = [("code", SYMBOL, 32),("date", INT),("time", INT),("last", FLOAT),("volume", INT),("value", FLOAT),("ask1", FLOAT),("ask2", FLOAT),("ask3", FLOAT),("ask4", FLOAT),("ask5", FLOAT),("ask6", FLOAT),("ask7", FLOAT),("ask8", FLOAT),("ask9", FLOAT),("ask10", FLOAT),("ask_size1", INT),("ask_size2", INT),("ask_size3", INT),("ask_size4", INT),("ask_size5", INT),("ask_size6", INT),("ask_size7", INT),("ask_size8", INT),("ask_size9", INT),("ask_size10", INT),("bid1", FLOAT),("bid2", FLOAT),("bid3", FLOAT),("bid4", FLOAT),("bid5", FLOAT),("bid6", FLOAT),("bid7", FLOAT),("bid8", FLOAT),("bid9", FLOAT),("bid10", FLOAT),("bid_size1", INT),("bid_size2", INT),("bid_size3", INT),("bid_size4", INT),("bid_size5", INT),("bid_size6", INT),("bid_size7", INT),("bid_size8", INT),("bid_size9", INT),("bid_size10", INT)];
t=loadRecord("/home/DolphinDB/sample.bin",schema);
select code, date,time,last,volume,value,ask1,ask_size1,bid1,bid_size1 from t;
```

|code|date|time|last|volume|value|ask1|ask\_size1|bid1|bid\_size1|
|----|----|----|----|------|-----|----|----------|----|----------|
|601177.SH|20190902|91804000|0|0|0|11.45|200|11.45|200|
|601177.SH|20190902|92007000|0|0|0|11.45|200|11.45|200|

