# loadModuleFromScript {#loadmodulefromscript}

## Syntax {#section_bgm_51s_xyb .section}

`loadModuleFromScript(moduleNamespace, moduleScript, [reload=false])`

## Arguments {#section_ft5_51s_xyb .section}

-   **moduleNamespace** is a STRING scalar or vector indicating the module namespace\(s\). If there are dependencies between modules, namespaces for all modules must be provided.
-   **moduleScript** is a STRING scalar or vector indicating the module script\(s\).
-   **reload**\(optional\) is a Boolean value indicating whether to reload the module. If a module with the same name has been loaded before, this parameter must be set to true to make changes in *moduleScript* take effect. The default value is false.


## Details {#section_opd_v1s_xyb .section}

Parse scripts containing module definitions and load the modules. If module references are included in the scripts, the order of dependencies in the definition does not need to be considered as they will be automatically resolved.

## Examples {#section_psn_v1s_xyb .section}

``` {#codeblock_jhk_bbs_xyb}
moduleName = "test"
moduleScript = "module test \n def testFunc(x,y){ return x+y }"
loadModuleFromScript(moduleName,moduleScript)
go
test::testFunc(2,3)
// output: 5
```

If module references are included:

``` {#codeblock_iwn_2bs_xyb}
moduleNames = ["test2","test1"]
moduleScripts = [
"module test2
use test1
def func4(x,y){
return func1(x) + func2(y)
}
",
"module test1
def func1(x){
return x+1
}
def func2(x){
return x+2
}
def func3(x){
print(func1(x)+func2(x))
}
"
]
loadModuleFromScript(moduleNames,moduleScripts)
go

test1::func3(2)
// output: 7

test2::func4(2,3)
// output: 8
```

**Parent topic:**[Functions](../../Functions/category.md)

