# loadModule {#loadmodule}

## Syntax {#syntax}

`loadModule(name,[moduleDir])`

## Arguments {#arguments}

**name** is a string indicating the module name.

**moduleDir** is a string indicating the directory where the *.dos* and *.dom* files of modules are located.

## Details {#details}

Load the functions in a module or plug-in as DolphinDB built-in functions. If the module relies on other modules, the system will also load these modules. It must be executed by a logged-in user.

When the system starts up, the configuration parameter *moduleDir* determines the directory where the module is located:

-   If the configuration parameter is an absolute path, it is the directory where the search module is located.

-   If the configuration parameter is a relative path, the system will search in the three directories: HOMEDIR, WORKDIR and EXECDIR sequentially. If it is found, use the directory as *moduleDir*; if it cannot be found, use `<HOMEDIR> + "/" + <moduleDir>` as the absolute path of modules.

-   If the configuration parameter *moduleDir* is not set, it is the same as when setting it to a relative path.


If the module directory contains both a *.dos* file and a *.dom* file with the same name, the system will only load the *.dom* file.

**Note:** *loadModule* can only be used in the initialization script \(*dolphindb.dos* as the default file\) of the system.

Function `loadModule` has the same function with the configuration parameter *preloadModules*.

## Examples {#examples}

Example 1. Load modules:

```
loadModule("ta");

loadModule("system::log::fileLog");
```

Example 2. Load plugins:

```
loadModule("plugins::mysql");

loadModule("plugins::odbc");
```

Related command: [saveModule](../s/saveModule.md)

