# listRemotePlugins {#listremoteplugins}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`listRemotePlugins([pluginName], [pluginServerAddr])`

## Arguments {#id_mzp_slm_rzb}

**pluginName** \(optional\) is a string indicating the plugin name.

**pluginServerAddr** \(optional\) is a string indicating the HTTP address of the DolphinDB plugins repository that the system should use. It is recommended to specify it as "http://plugins.dolphindb.com/plugins".

## Details {#details}

`listRemotePlugins` returns a table listing the available DolphinDB plugins and their versions.

If *pluginName* is specified, the function returns the specified plugin. If the specified plugin does not exist, the function returns an empty record. If *pluginName* is not specified, the function returns all the specified plugins.

**Note**: The returned plugin information is based on DolphinDB server version and the operation system.

## Examples {#example}

List all available plugins:

``` {#codeblock_nzg_hrx_l1c}
listRemotePlugins()
```

Return a plugin list:

|PluginName|PluginVersion|
|----------|-------------|
|hdf5|*&lt;PluginVersion&gt;*|
|matchEngine|*&lt;PluginVersion&gt;*|
|mongodb|*&lt;PluginVersion&gt;*|
|mqtt|*&lt;PluginVersion&gt;*|
|mseed|*&lt;PluginVersion&gt;*|
|mysql|*&lt;PluginVersion&gt;*|
|nsq|*&lt;PluginVersion&gt;*|
|odbc|*&lt;PluginVersion&gt;*|
|opc|*&lt;PluginVersion&gt;*|
|opcua|*&lt;PluginVersion&gt;*|
|zip|*&lt;PluginVersion&gt;*|

*&lt;PluginVersion&gt;* refers to the version information of the plugin, such as "2.00.11" and "1.30.23".

Related function: [installPlugin](../i/installPlugin.md)

