# lastWeekOfMonth {#lastweekofmonth}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`lastWeekOfMonth(X, [weekday=0], [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector of type DATE, DATETIME, TIMESTAMP or NANOTIMESTAMP.

**weekday** is an integer from 0 to 6. 0 means Monday, 1 means Tuesday, ..., and 6 means Sunday. The default value is 0.

**offset** is a scalar of the same data type as *X*. It must be no greater than the minimum value of *X*. The default value is the minimum value of *X*.

**n** is a positive integer. The default value is 1.

## Details {#details}

In the calendar month of *X*, suppose the last "weekday" is d.

-   If *X* &lt;d: return the last "weekday" in the previous calendar month.

-   If *X* &gt;=d: return the last "weekday" in the current calendar month.


If parameter *offset* is specified, the result is updated every *n* months. Parameter *offset* works only if parameter *n* &gt;1.

## Examples {#examples}

```
lastWeekOfMonth(2019.11.24,2);
// output: 2019.10.30
// The last Wednesday of November 2019 is 2019.11.27, 2019.11.24 is before 2019.11.27, so the function returns the last Wednesday of October 2019.

lastWeekOfMonth(2019.11.29,2);
// output: 2019.11.27

date=2012.01.02 2012.02.03 2012.03.07 2012.04.08 2012.05.12 2012.06.16 2012.07.18 2012.08.20 2012.09.25 2012.10.28
time = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12,09:38:13]
sym = take(`MSFT,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, time, sym, qty, price);

select avg(price),sum(qty) from t1 group by lastWeekOfMonth(date,4,2012.01.01,2);
```

|lastWeekOfMonth\_date|avg\_price|sum\_qty|
|---------------------|----------|--------|
|2011.12.30|39.53|4100|
|2012.02.24|29.77|5300|
|2012.04.27|175.1|12200|
|2012.06.29|50.54|3800|
|2012.08.31|51.29|8800|
|2012.10.26|52.38|4500|

