# lassoCV {#lassocv}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`lassoCV(ds, yColName, xColNames, [alphas], [intercept], [normalize], [maxIter], [tolerance], [positive], [swColName], [checkInput])`

## Arguments {#arguments}

The `lassoCV` function inherits all parameters of function [lasso](lasso.md), with one added parameter, *alphas*.

**alphas** \(optional\) is a floating-point scalar or vector that represents the coefficient multiplied by the L1 norm penalty term. The default value is \[0.01, 0.1, 1.0\].

## Details {#details}

Estimate a Lasso regression using 5-fold cross-validation and return a model corresponding to the optimal parameters.

**Return value**: A dictionary containing the following keys

-   modelName: the model name, which is "LassoCV" for this method

-   coefficients: the regression coefficients

-   intercept: the intercept

-   dual\_gap: the dual gap

-   tolerance: the tolerance for the optimization

-   iterations: the number of iterations

-   xColNames: the column names of the independent variables in the data source

-   predict: the function used for prediction

-   alpha: the penalty term for cross-validation


## Examples {#examples}

``` {#codeblock_krn_tsk_21c}
y = [225.720746,-76.195841,63.089878,139.44561,-65.548346,2.037451,22.403987,-0.678415,37.884102,37.308288]
x0 = [2.240893,-0.854096,0.400157,1.454274,-0.977278,-0.205158,0.121675,-0.151357,0.333674,0.410599]
x1 = [0.978738,0.313068,1.764052,0.144044,1.867558,1.494079,0.761038,0.950088,0.443863,-0.103219]
t = table(y, x0, x1);

lassoCV(t, `y, `x0`x1);

/* output:
modelName->lassoCV
coefficients->[94.4493,14.3046]
intercept->0.0313
dual_gap->0.0009
tolerance->0.0001
iterations->5
xColNames->["x0","x1"]
predict->coordinateDescentPredict
alpha->0.01
*/
```

