# kurtosis {#kurtosis}

## Syntax {#syntax}

`kurtosis(X, [biased=true])`

## Arguments {#arguments}

**X** is a vector/matrix.

**biased** is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

## Details {#details}

Return the kurtosis of *X*. The calculation skips null values.

The calculation uses the following formulas:

-   when *biased* =true:

    ![](../../images/k1.png)

-   when *biased*=false:

    ![](../../images/k0.png)


If *X* is a matrix, calculate the skewness of each column of *X* and return a vector.

If *X* is a table, calculate the skewness of each column of *X* and return a table.

`kurtosis` also supports querying partitioned tables and distributed tables with bias correction.

Function `kurtosis` in DolphinDB returns a biased result by default \(*biased* = true\), while in pandas and Excel it is unbiased estimation, and the kurtosis value 3 of the normal distribution is subtracted.

Refer to the following example, you can make the kurtosis results of DolphinDB consistent with that of pandas and excel:

```
// python
m = [1111, 323, 43, 51]
df = pandas.DataFrame(m)
y = df.kurt()
// output: 2.504252

// dolphindb
m=matrix(1111 323 43 51)
kurtosis(m, false) - 3
// output: 2.5043
```

## Examples {#examples}

Please note that as the example below uses the random number generator [norm](../n/norm.md), the result is slightly different each time it is executed.

```
x=norm(0, 1, 1000000);
kurtosis(x);
// output: 3.000249

x[0]=100;
kurtosis(x);
// output: 100.626722

m=matrix(1..10, 1 2 3 4 5 6 7 8 9 100);
m;
```

|\#0|\#1|
|---|---|
|1|1|
|2|2|
|3|3|
|4|4|
|5|5|
|6|6|
|7|7|
|8|8|
|9|9|
|10|100|

```
kurtosis(m);
// output: [1.775757575757576,7.997552566718839]
```

