# kroghInterpolateFit {#kroghInterpolateFit}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`kroghInterpolateFit(X, Y, [der=0])`

## Arguments {#arguments}

**X** is a numeric vector representing the x-coordinates of the points to be interpolated. Values in *X* must be in increasing order. Null values are not allowed.

**Y** is a numeric vector of the same length as *X*, representing the y-coordinates of the points. Null values are not allowed.

**der** \(optional\) is a non-negative integer representing the derivative order to compute. The default value is 0, meaning to compute the polynomial's value.

## Details {#details}

This function performs polynomial interpolation for a given set of points, ensuring the polynomial passes through all points in the set.

Multiple derivative values at each point of *X* can be specified by repeating *X* values and assigning corresponding derivative values as consecutive Y values:

-   If an *X* value appears only once, the corresponding *Y* is the value of the polynomial f\(X\).
-   If an *X* value appears multiple times, the first *Y* is the value of f\(X\), the second Y is the first derivative f′\(X\), the third Y is the second derivative f′′\(X\), and so on. For example, with inputs X=\[0,0,1,1\] and Y=\[1,0,2,3\], the interpretation is Y\[0\]=f\(0\), Y\[1\]=f′\(0\), Y\[2\]=f\(1\), Y\[3\]=f′\(1\).

**Return value**: A dictionary with the following keys:

-   modelName: A string "kroghInterpolate" indicating the model name.
-   X: The numeric vector representing the x-coordinates used for interpolation \(i.e., the input *X*\).
-   der: The non-negative integer representing the derivative order \(i.e., the input *der*\).
-   coeffs: A numeric vector containing the polynomial coefficients fitted from the input data points.
-   predict: The prediction function of the model. You can call `model.predict(X)` or `predict(model, X)` to make predictions with the generated model. It takes the following parameters:
    -   model: A dictionary, which is the output of `kroghInterpolateFit`.
    -   X: A numeric vector representing the x-coordinates at which to evaluate the polynomial.

## Examples {#examples}

Perform polynomial interpolation for the `sin` function and compute the polynomial estimates at specific points:

``` {#codeblock_bgv_gfs_cdc}
x = 0 1 2 3 4 5
y = sin(x)
model = kroghInterpolateFit(x,y)
model

/*
output:
X->[0,1,2,3,4,5]
der->0
predict->kroghInterpolateFitPredict
modelName->kroghInterpolate
coeffs->[0.0,0.841470984807,-0.386822271395,-0.010393219665,0.032025753923,-0.005411092181,0.0]
*/
```

Predict with the generated model using a UDF `linspace`:

``` {#codeblock_iwp_hfs_cdc}
def linspace(start, end, num, endpoint=true){
	if(endpoint) return end$DOUBLE\(num-1), start + end$DOUBLE\(num-1)*0..(num-1)
	else return start + end$DOUBLE\(num-1)*0..(num-1)	
}
xx = linspace(0.0, 5.0, 10)[1]
model.predict(xx)

// output: [0,0.515119011157387,0.898231239576709,0.998548648650381,0.793484053410063,0.354287125066207,-0.188319604452395,-0.678504737959061,-0.969692008469677,-0.958924274663139]
```

**Related Functions**: [predict](../p/predict.md), [kroghInterpolate](kroghInterpolate.md)

