# kroghInterpolate {#kroghInterpolate}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#topic_hdp_3mm_cbc}

`kroghInterpolate(X, Y, newX, [der=0])`

## Arguments {#topic_cz5_3mm_cbc}

**X** is a numeric vector indicating the x-coordinates. It must be sorted in increasing order with no null values contained.

**Y** is a numeric vector of the same length as *Xi*, indicating the y-coordinates. It cannot contain null values.

**newX** is a numeric vector specifying the points at which to evaluate the derivatives.

**der** \(optional\) is a non-negative integer indicating how many derivatives to evaluate. The default value is 0, meaning the function value is used as the 0th derivative.

## Details {#topic_k3w_3mm_cbc}

Interpolating polynomial for a set of points. The polynomial passes through all the pairs `(X, Y)` and returns the derivative interpolated at the x-points.

One may additionally specify a number of derivatives at each point *Xi*; this is done by repeating the value *Xi* and specifying the derivatives as successive *Yi* values.

-   When the vector of *Xi*contains only distinct values, *Yi* represents the function value.

-   When an element of *Xi*occurs two or more times in a row, the corresponding *Yi* represents derivative values. For example, if X = \[0,0,1,1\] and Y = \[1,0,2,3\], then Y\[0\]=f\(0\), Y\[1\]=f'\(0\), Y\[2\]=f\(1\) and Y\[3\]=f'\(1\).


## Examples {#topic_t1y_3mm_cbc}

Take `sin` as an example to interpolate the value and first derivative at the point of xx.

``` {#codeblock_oyz_mmm_cbc}
def linspace(start, end, num, endpoint=true){
	if(endpoint) return end$DOUBLE\(num-1), start + end$DOUBLE\(num-1)*0..(num-1)
	else return start + end$DOUBLE\(num-1)*0..(num-1)	
}

x = 0 1 2 3 4 5
y = sin(x)
xx = linspace(0.0, 5.0, 10)[1]
yy=kroghInterpolate(x,y,xx)
yy;
// output: [0,0.515119011157387,0.898231239576709,0.998548648650381,0.793484053410063,0.354287125066207,-0.188319604452395,-0.678504737959061,-0.969692008469677,-0.958924274663139]

yy1=kroghInterpolate(x,y,xx,1)
yy1;
// output: [0.885486080979582,0.875967413938641,0.459031117252456,-0.103633680213926,-0.612193041424271,-0.92866822117116,-0.976935666075988,-0.742727014588963,-0.273629096989106,0.320916064615744]
```

