# kendall {#kendall}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`kendall(X, Y)`

## Arguments {#arguments}

**X** is a scalar, vector, matrix or in-memory table.

**Y** is a scalar, vector, matrix or in-memory table.

## Details {#details}

Calculate the [Kendall rank correlation coefficient](https://en.wikipedia.org/wiki/Kendall_rank_correlation_coefficient) between *X* and *Y*. Null values are ignored in the calculation.

If *X* or *Y* is a matrix, perform the aforementioned calculation on each column and return a vector.

If *X* or *Y* is an in-memory table, perform the aforementioned calculation on each numeric column of the table and return a table \(where null values are returned for non-numeric columns\).

## Examples {#examples}

``` {#codeblock_rfn_hhf_f1c}
x = [33,21,46,-11,78,47,18,20,-5,66]
y = [1,NULL,10,6,10,3,NULL,NULL,5,3]
kendall(x, y)
// output: 0.05
```

If *X* is a matrix, *Y* can be a vector of the same length as the number of rows in *X*, or a matrix of the same dimension as *X*. The result is a vector of the same length as the number of columns in *X*.

``` {#codeblock_hyq_khf_f1c}
m=1..20$10:2
kendall(x,m)
// output: [-0.0222,-0.0222]

n=rand(20,20)$10:2
kendall(m,n)
// output: [0.3865,-0.1591]
```

If *X* is a table, *Y* can be a vector of the same length as the number of rows in *X*, or a table of the same dimension as *X*. The result is a vector of the same length as the number of columns in *X*.

``` {#codeblock_ezg_lhf_f1c}
t=table(2..11 as id, "a"+string(2..11) as name)
kendall(t,x)
/* output:
id	     name
-0.0222
*/	

t1=table(x as col1, y as col2)
kendall(t,t1)
/* output:
id	     name
-0.0222
*/
```

