# join {#join}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`join(X,Y)` or `X<-Y`

## Arguments {#arguments}

**X** and **Y** can be scalar/vector/matrix/table.

## Details {#details}

Merge X and Y.

## Examples {#examples}

If X is a scalar, Y can be a scalar/vector. The result is a vector.

```
1<-3;
// output: [1,3]

4<-1 2 3;
// output: [4,1,2,3]
```

If X is a vector, Y must be a scalar/vector. The result is a vector.

```
[1,2,3]<-4;
// output: [1,2,3,4]

[1,2,3]<-[4,5,6];
// output: [1,2,3,4,5,6]
```

If X is a matrix, Y must be a vector/matrix with the same number of rows as X. The result is a matrix with the same number of rows as X.

```
1..6$2:3 <- [7,8];
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|1|3|5|7|
|2|4|6|8|

```
(1..6$2:3) <- (7..12$2:3);
```

|\#0|\#1|\#2|\#3|\#4|\#5|
|---|---|---|---|---|---|
|1|3|5|7|9|11|
|2|4|6|8|10|12|

If X is a table, Y must be a table or a vector with the same number of rows as X. The result is a table with the same number of rows as X.

```
a=table(1..3 as x, 4.5 6.7 8.5 as y);
a;
```

|x|y|
|---|---|
|1|4.5|
|2|6.7|
|3|8.5|

```
b=table(700 500 800 as z);
b
```

|z|
|---|
|700|
|500|
|800|

```
c=join(a,b);
c;
```

|x|y|z|
|---|---|---|
|1|4.5|700|
|2|6.7|500|
|3|8.5|800|

```
a=table(1..3 as x, `IBM`C`AAPL as y);
b=table(172.3 25 106.5 as z);
c=a<-b;
c
```

|x|y|z|
|---|---|---|
|1|IBM|172.3|
|2|C|25|
|3|AAPL|106.5|

Related function: [cj \(cross\_join\)](../c/cj.md)

