# isortTop {#isorttop}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`isortTop(X, top, [ascending=true])`

## Arguments {#arguments}

**X** is a vector or a tuple of vectors of the same length.

**top** is a positive integer no more than the size of a vector in *X*.

**ascending** is a Boolean scalar or vector indicating whether to sort *X* \(or vectors of *X* sequentially\) in ascending order or descending order. The default value is true \(ascending order\).

## Details {#details}

Return the first few elements of the result of `isort(X, [ascending])`.

## Examples {#examples}

```
isortTop(2 1 4 3 6 5, 3);
// output: [1,0,3]

isortTop(2 1 4 3 6 5, 3, false);
// output: [4,5,2]
```

The following example first sorts m in descending order. For the identical elements in m, sort them based on descending n values at the corresponding positions. Return the original indices of the first three elements of sorted m.

```
m=1 1 2 2 3 3
n=1 2 1 2 1 2
isortTop([m,n], 3, [false, false]);
// output: [5,4,3]
```

