# isort! {#isort}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`isort!(X, [ascending=true], indices)`

## Arguments {#arguments}

**X** is a vector or a tuple of vectors of the same length.

**ascending** is a Boolean scalar indicating whether to sort *X* \(or vectors of *X* sequentially\) in ascending order or descending order. The default value is true \(ascending order\).

**indices** is a vector of the same length as each vector in *X*.

## Details {#details}

`isort!(x, ascending, y)` is equivalent to `y[isort(x,ascending)]`. The result is assigned to *y*.

## Examples {#examples}

```
x=3 1 NULL 2
y=5 7 8 3
isort!(x, false, y);
// output: [5, 3, 7, 8]
// after sorted, x is [3, 2, 1, NULL], the first element 3 is corresponding to 5 in y, the second element 2 is corresponding to 3 in y, the third element 1 is corresponding to 7 in y, ... and so on.

x=2 2 1 1
y=2 1 1 2
isort!([x,y],[1,0],5 4 3 2);
// output: [2,3,5,4]
```

