# irs {#irs}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`irs(settlement, resetInterval, start, maturity, notional, fixedRate, spread, curve, frequency, calendar, [convention='ModifiedFollowing'], [basis=1], [rateType=0])`

## Arguments {#arguments}

**Note:** Scalar inputs will be automatically expanded to match the length of other vector inputs. All vector inputs must be of equal length.

**settlement** is a DATE scalar or vector indicating the settlement date.

**resetInterval**is a DURATION scalar or vector indicating how often the interest rate is reset.

**start** is a DATE scalar or vector indicating the start date.

**maturity** is a DATE scalar or vector indicating the maturity date.

**notional** is a numeric scalar or vector indicating the notional amount.

**fixedRate** is a numeric scalar or vector indicating the fixed rate\(s\).

**spread** is a numeric scalar or vector indicating the interest rate spread.

**curve** is a dictionary scalar or vector indicating the fitted yield curve.

**frequency** is an INT scalar/vector indicating the number of payments, or a STRING scalar/vector indicating payment frequency. It can be:

-   0/"Once": Bullet payment at maturity.
-   1/"Annual": Annual payments.
-   2/"Semiannual": Semi-annual payments.
-   4/"Quarterly": Quarterly payments.
-   12/"Monthly": Monthly payments.

**calendar** is a STRING scalar or vector indicating the trading calendar\(s\). See [Trading Calendar](../../Tutorials/trading_calendar.md) for more information.

**convention** \(optional\) is a STRING scalar or vector indicating how cash flows that fall on a non-trading day are treated. The following options are available. Defaults to 'ModifiedFollowing'.

-   'Following': The following trading day.
-   'ModifiedFollowing': The following trading day. If that day is in a different month, the preceding trading day is adopted instead.
-   'Preceding': The preceding trading day.
-   'ModifiedPreceding': The preceding trading day. If that day is in a different month, the following trading day is adopted instead.
-   'Unadjusted': Unadjusted.
-   'HalfMonthModifiedFollowing': The following trading day. If that day crosses the mid-month \(15th\) or the end of month, the preceding trading day is adopted instead.
-   'Nearest': The nearest trading day. If both the preceding and following trading days are equally far away, default to following trading day.

**rateType** \(optional\) is an INT/STRING scalar or vector indicating compound interest. It can be:

-   0/"CC" \(default\): continuous compounding
-   1/"C": discrete compounding

## Details {#details}

The `irs` function prices an interest rate swap \(IRS\) for the floating-rate side.

An IRS is a derivative contract in which two parties agree to exchange one stream of interest payments for another over a set period of time. The most commonly traded IRS is the exchange of a fixed interest rate payment and a floating rate payment \(typically benchmarked to an interbank offered rate LIBOR\).

**Return Value**: A DOUBLE scalar or vector.

## Examples {#examples}

This example describes an interest rate swap where fixed and floating rate payments are exchanged weekly over a 5-year period \(2023.07.10-2028.01.10\). The swap uses the XNYS calendar for determining trading days and applies a US \(NASD\) 30/360 day-count basis and continuous compounding for interest calculations.

``` {#codeblock_ndc_jxx_gdc}
settlement = 2023.07.10
calendar = `XNYS
day0 = temporalAdd(settlement, 0, calendar)
curveRateTime = [10y, 14d, 1d, 1M, 1y, 2y, 3M, 3y, 4y, 5y, 6M, 7d, 7y, 9M]
curveRateValue = [ 2.7013, 1.8, 1.27, 1.9425, 2.0263, 2.1265, 1.9725, 2.2438, 2.3575, 2.4538, 1.9938, 1.86, 2.5863, 2.0088] * 0.01
dates = []
for (dur in curveRateTime) {
	dates.append!(temporalAdd(settlement, dur))
}
X = (dates - day0)$INT
// a curve for base rate (without spread)
curve = linearInterpolateFit(X, curveRateValue)
resetIntv = 7d
start = 2023.01.10
maturity = 2028.01.10
notional = 100.0
fixedRate = 0.02765
spread = 0.0
freq = 3M
basis = 0
irs(settlement, resetIntv, start, maturity, notional, fixedRate, spread, curve, freq, calendar, basis = basis)
// -1.54
```

