# irSingleCurrencyCurveBuilder {#irSingleCurrencyCurveBuilder}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`irSingleCurrencyCurveBuilder(referenceDate, currency, instNames, instTypes, terms, quotes, dayCountConvention, [discountCurve], [compounding='Continuous'], [frequency='Annual'], [curveName])`

## Details {#topic_ptx_qvq_ngc}

Build a yield curve using single-currency interest rate swaps. Currently, only CNY\_FR\_007 and CNY\_SHIBOR\_3M curves are supported.

**Return value:**A MKTDATA object.

## Arguments {#arguments}

**referenceDate** A DATE scalar indicating the reference date of the curve.

**currency** A STRING scalar indicating the currency in which the curve is defined. Currently, only "CNY" is supported.

**instNames** A STRING vector indicating the instrument names.

**instTypes** A STRING vector indicating the instrument types. Currently supports "Deposit" and "IrVanillaSwap".

**terms** A vector of DURATION type, indicating the remaining maturity, e.g., "1M".

**quotes** A numeric vector indicating the market quotes.

**dayCountConvention**A STRING scalar indicating the day count convention to use. It can be:

-   "Actual360": actual/360

-   "Actual365": actual/365

-   "ActualActualISMA": actual/actual according to ISMA \(International Securities Market Association\) convention

-   "ActualActualISDA": actual/actual according to ISDA \(International Swaps and Derivatives Association\) convention.


**discountCurve** \(optional\) An MKTDATA object of type IrYieldCurve indicating the discount curve. See [Curve Field Specifications](#topic_oqh_xvq_ngc) for details.

-   If the market instruments used for building the target curve require an external discount curve for pricing, specify it using this parameter.

-   If not provided, no external discount curve will be used by default.


**compounding** \(optional\) A STRING scalar specifying the compounding interest. It can be:

-   "Compounded": discrete compounding

-   "Simple": simple interest \(no compounding\).

-   "Continuous" \(default\): continuous compounding.


**frequency** \(optional\) A STRING scalar specifying the interest payment frequency. Supported values:

-   "NoFrequency": No payment frequency

-   "Annual": Annually

-   "Semiannual": Semiannually

-   "EveryFourthMonth": Every four months

-   "Quarterly": Quarterly

-   "BiMonthly": Every two months

-   "Monthly": Monthly

-   "EveryFourthWeek": Every four weeks

-   "BiWeekly": Every two weeks

-   "Weekly": Weekly

-   "Daily": Daily

-   "Other": Other frequencies


**curveName** \(optional\) A STRING scalar indicating the yield curve name. The default value is NULL.

## Examples {#examples}

Example 1. Build a CNY-denominated interest rate swap curve referencing the FR007 floating rate.

``` {#codeblock_y55_32x_mgc}
referenceDate = 2021.05.26
currency = "CNY"
terms = [7d, 1M, 3M, 6M, 9M, 1y, 2y, 3y, 4y, 5y, 7y, 10y]
instNames = take("CNY_FR_007", size(terms))
instNames[0] = "FR_007"
instTypes = take("IrVanillaSwap", size(terms))
instTypes[0] = "Deposit"
quotes = [2.3500, 2.3396, 2.3125, 2.3613, 2.4075, 2.4513, 2.5750, 2.6763, 2.7650, 2.8463, 2.9841, 3.1350]\100
dayCountConvention = "Actual365"
curve = irSingleCurrencyCurveBuilder(referenceDate, currency, instNames, instTypes, terms, quotes, dayCountConvention, curveName="CNY_FR_007")
curveDict = extractMktData(curve)
print(curveDict)
```

Example 2. Build a CNY interest rate swap yield curve based on short-term deposit and interest rate swap market quotes.

``` {#codeblock_sy1_vvq_ngc}
referenceDate = 2021.05.26
currency = "CNY"
terms = [1w, 2w, 1M, 3M, 6M, 9M, 1y, 2y, 3y, 4y, 5y, 7y, 10y]
instNames = take("CNY_SHIBOR_3M", size(terms))
instNames[0] = "SHIBOR_1W"
instNames[1] = "SHIBOR_2W"
instNames[2] = "SHIBOR_1M"
instNames[3] = "SHIBOR_3M"
instTypes = take("IrVanillaSwap", size(terms))
instTypes[0] = "Deposit"
instTypes[1] = "Deposit"
instTypes[2] = "Deposit"
instTypes[3] = "Deposit"
quotes = [2.269,
          2.311,
          2.405,
          2.479,
          2.6013,
          2.7038,
          2.7725,
          2.9625,
          3.11,
          3.24,
          3.3513,
          3.5313,
          3.7125]/100
dayCountConvention = "Actual365"
curve = irSingleCurrencyCurveBuilder(referenceDate, currency, instNames, instTypes, terms, quotes, dayCountConvention)
curveDict = extractMktData(curve)
print(curveDict)
```

Example 3. Build a dual-curve interest rate swap yield curve \(CNY\_SHIBOR\_3M\).

``` {#codeblock_i11_wvq_ngc}
referenceDate = 2021.05.26
currency = "CNY"
curveName = "CNY_SHIBOR_3M"
discountCurve = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "curveName": "CNY_FR_007",
    "referenceDate": referenceDate,
    "currency": "CNY",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "dates":[2021.06.02,2021.06.28,2021.08.27,2021.11.29,2022.02.28,2022.05.27,2023.05.29,2024.05.27,2025.05.27,2026.05.27,2028.05.29,2031.05.27],
    "values": [2.3495, 2.3376, 2.3063, 2.3543, 2.4004, 2.4442, 2.5686, 2.6715, 2.7625, 2.8468, 2.9922, 3.1559] / 100.0
}
discountCurve = parseMktData(discountCurve)
terms = [1w, 2w, 1M, 3M, 6M, 9M, 1y, 2y, 3y, 4y, 5y, 7y, 10y]
instNames = take("CNY_SHIBOR_3M", size(terms))
instNames[0] = "SHIBOR_1W"
instNames[1] = "SHIBOR_2W"
instNames[2] = "SHIBOR_1M"
instNames[3] = "SHIBOR_3M"
instTypes = take("IrVanillaSwap", size(terms))
instTypes[0] = "Deposit"
instTypes[1] = "Deposit"
instTypes[2] = "Deposit"
instTypes[3] = "Deposit"
quotes = [2.269,
          2.311,
          2.405,
          2.479,
          2.6013,
          2.7038,
          2.7725,
          2.9625,
          3.11,
          3.24,
          3.3513,
          3.5313,
          3.7125]/100
dayCountConvention = "Actual365"

curve = irSingleCurrencyCurveBuilder(referenceDate, currency, instNames, instTypes, terms, quotes, dayCountConvention, discountCurve)
curveDict = extractMktData(curve)
print(curveDict)
```

**Releated functions:**[bondYieldCurveBuilder](../b/bondYieldCurveBuilder.md), [extractMktData](../e/extractMktData.md), [irCrossCurrencyCurveBuilder](irCrossCurrencyCurveBuilder.md), [parseMktData](../p/parseMktData.md)

## Curve Field Specifications {#topic_oqh_xvq_ngc}

<table id="table_a1k_1m1_4gc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

mktDataType

</td><td>

STRING

</td><td>

Must be "Curve"

</td><td>

√

</td></tr><tr><td>

referenceDate

</td><td>

DATE

</td><td>

Reference Date

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

curveType

</td><td>

STRING

</td><td>

Must be "IrYieldCurve"

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention to use. It can be:

 -   "Actual360": actual/360

-   "Actual365": actual/365

-   "ActualActualISMA": actual/actual according to ISMA \(International Securities Market Association\) convention

-   "ActualActualISDA": actual/actual according to ISDA \(International Swaps and Derivatives Association\) convention.


</td><td>

√

</td></tr><tr><td>

interpMethod

</td><td>

STRING

</td><td>

Interpolation method. It can be:

 -   "Linear": linear interpolation

-   "CubicSpline": cubic spline interpolation

-   "CubicHermiteSpline": cubic Hermite interpolation


</td><td>

√

</td></tr><tr><td>

extrapMethod

</td><td>

STRING

</td><td>

Extrapolation method. It can be

 -   Flat: flat extrapolation

-   Linear: linear extrapolation


</td><td>

√

</td></tr><tr><td>

dates

</td><td>

DATE vector

</td><td>

Date of each data point

</td><td>

√

</td></tr><tr><td>

values

</td><td>

DOUBLE vector

</td><td>

Value of each data point, corresponding to the elements in dates.

</td><td>

√

</td></tr><tr><td>

curveName

</td><td>

STRING

</td><td>

Curve name

</td><td>

×

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency. It can be CNY", "USD", "EUR", "GBP", "JPY", "HKD"

</td><td>

√

</td></tr><tr><td>

compounding

</td><td>

STRING

</td><td>

The compounding interest. It can be:

 -   "Compounded": discrete compounding

-   "Simple": simple interest \(no compounding\).

-   "Continuous": continuous compounding.


</td><td>

√

</td></tr><tr><td>

settlement

</td><td>

DATE

</td><td>

Settlement date. If specified, all subsequent tenor intervals are computed starting from "settlement" rather than from "referenceDate".

</td><td>

×

</td></tr><tr><td>

frequency

</td><td>

INTEGRAL/STRING

</td><td>

The interest payment frequency. Supported values:

 -   -1 or "NoFrequency": No payment frequency

-   0 or "Once": Single lump-sum payment of principal and interest at maturity.

-   1 or "Annual": Annually

-   2 or "Semiannual": Semiannually

-   3 or "EveryFourthMonth": Every four months

-   4 or "Quarterly": Quarterly

-   6 or "BiMonthly": Every two months

-   12 or "Monthly": Monthly

-   13 or "EveryFourthWeek": Every four weeks

-   26 or "BiWeekly": Every two weeks

-   52 or "Weekly": Weekly

-   365 or "Daily": Daily

-   999 or "Other": Other frequencies


</td><td>

×

</td></tr><tr><td>

curveModel

</td><td>

STRING

</td><td>

Curve construction model; Currently, only "Bootstrap" is supported.

</td><td>

×

</td></tr><tr><td>

curveParams

</td><td>

DICT

</td><td>

Model parameters.

</td><td>

×

</td></tr></tbody>
</table>