# irFixedFloatingSwapPricer {#irFixedFloatingSwapPricer}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`irFixedFloatingSwapPricer(instrument, pricingDate, discountCurve, forwardCurve, assetPriceCurve, [setting])`

## Details {#topic_tqm_hcr_ngc}

Prices an IR Fixied-Floating Swap.

**Return value:**

-   If specify calcCashFlow in *setting*, it returns a dictionary.

-   Otherwise, it returns a DOUBLE scalar.


## Arguments {#arguments}

**instrument** is an INSTRUMENT scalar of IrFixedFloatingSwap type representing the IR Fixied-Floating Swap to be priced.

**pricingDate** is a DATE scalar specifying the pricing date.

**discountCurve** is a MKTDATA scalar of IrYieldCurve type representing the spot curve used to compute discount factors.

**forwardCurve** is a MKTDATA scalar of IrYieldCurve type representing the spot curve used to compute forward rates.

**assetPriceCurve** is a MKTDATA scalar of AssetPriceCurve type used to pass the historical data for the floating reference rate of an interest rate swap.

**setting** \(optional\)is a Dictionary&lt;STRING, ANY&gt; specifying the calculation configuration with the following key-value pair:

|key|value|describe|
|---|-----|--------|
|calcCashFlow|BOOL|whether to calculate cash flow|

## Examples {#examples}

Example 1. Interest rate swap pricing based on FR\_007 as the reference rate.

```
irs =  {
    "productType": "Swap",
    "swapType": "IrSwap",
    "irSwapType": "IrFixedFloatingSwap",
    "version": 0, 
    "start": 2025.06.16,
    "maturity": 2028.06.16,
    "frequency": "Quarterly",
    "fixedRate": 0.018,
    "calendar": "CFET", 
    "fixedDayCountConvention": "Actual365",
    "floatingDayCountConvention": "Actual365",
    "payReceive": "Pay",
    "iborIndex": "FR_007",
    "spread": 0.0001,
    "notional":["CNY", 1E8]
}

pricingDate = 2025.08.18

curve = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "version": 0,
    "referenceDate": pricingDate,
    "currency": "CNY",
    "curveName": "CNY_FR_007",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",     
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates":[2025.08.21, 2025.08.27, 2025.09.03, 2025.09.10, 2025.09.22, 2025.10.20, 2025.11.20, 
             2026.02.24, 2026.05.20, 2026.08.20, 2027.02.22, 2027.08.20,2028.08.21],
    "values":[1.4759, 1.5331, 1.5697, 1.5239, 1.4996, 1.5144, 1.5209,
              1.5539, 1.5461, 1.5316, 1.5376, 1.5435,1.5699] / 100
}

// To calculate the floating rate used for the first cash flow after the valuation date, historical data of the reference rate must be provided.
// Since the payment frequency of the FR_007 interest rate swap is quarterly, it is recommended to provide no fewer than 70 trading days of historical FR_007 fixing data.
fr007HistCurve = {
    "mktDataType": "Curve",
    "curveType": "AssetPriceCurve",
    "version": 0,
    "referenceDate": pricingDate,
    "currency": "CNY",
    "dates":[2025.05.09, 2025.05.12, 2025.05.13, 2025.05.14, 2025.05.15, 2025.05.16, 2025.05.19, 2025.05.20, 2025.05.21, 2025.05.22,
             2025.05.23, 2025.05.26, 2025.05.27, 2025.05.28, 2025.05.29, 2025.05.30, 2025.06.03, 2025.06.04, 2025.06.05, 2025.06.06,
             2025.06.09, 2025.06.10, 2025.06.11, 2025.06.12, 2025.06.13, 2025.06.16, 2025.06.17, 2025.06.18, 2025.06.19, 2025.06.20,
             2025.06.23, 2025.06.24, 2025.06.25, 2025.06.26, 2025.06.27, 2025.06.30, 2025.07.01, 2025.07.02, 2025.07.03, 2025.07.04,
             2025.07.07, 2025.07.08, 2025.07.09, 2025.07.10, 2025.07.11, 2025.07.14, 2025.07.15, 2025.07.16, 2025.07.17, 2025.07.18,
             2025.07.21, 2025.07.22, 2025.07.23, 2025.07.24, 2025.07.25, 2025.07.28, 2025.07.29, 2025.07.30, 2025.07.31, 2025.08.01,
             2025.08.04, 2025.08.05, 2025.08.06, 2025.08.07, 2025.08.08, 2025.08.11, 2025.08.12, 2025.08.13, 2025.08.14, 2025.08.15
       ],
    "values":[1.6000, 1.5600, 1.5300, 1.5500, 1.5500, 1.6300, 1.6500, 1.6000, 1.5900, 1.5800, 
              1.6300, 1.7000, 1.7000, 1.7000, 1.7500, 1.7500, 1.5900, 1.5800, 1.5700, 1.5600, 
              1.5500, 1.5500, 1.5600, 1.5900, 1.5900, 1.5700, 1.5500, 1.5600, 1.5679, 1.6000, 
              1.5700, 1.8500, 1.8300, 1.8400, 1.8500, 1.9500, 1.6036, 1.5800, 1.5200, 1.5000, 
              1.5000, 1.5100, 1.5100, 1.5300, 1.5200, 1.5500, 1.6000, 1.5400, 1.5400, 1.5000, 
              1.5000, 1.4800, 1.5000, 1.6000, 1.7500, 1.6400, 1.6200, 1.6300, 1.6000, 1.5000, 
              1.4800, 1.4700, 1.4800, 1.4900, 1.4600, 1.4600, 1.4600, 1.4800, 1.4800, 1.4900  
               ]\100
}

instrument = parseInstrument(irs)
curve = parseMktData(curve)
discountCurve = curve
forwardCurve = curve
assetPriceCurve = parseMktData(fr007HistCurve)

// Calculate npv
npv = irFixedFloatingSwapPricer(instrument, pricingDate, discountCurve, forwardCurve, assetPriceCurve)
print(npv)

// Calculate npv, cash flow
setting = {
    "calcCashFlow": true
}
results = irFixedFloatingSwapPricer(instrument, pricingDate, discountCurve, forwardCurve, assetPriceCurve, setting)
print(results)
```

Example 2. Interest rate swap pricing based on SHIBOR\_3M as the reference rate.

``` {#codeblock_tmn_hkv_4gc}
irs =  {
    "productType": "Swap",
    "swapType": "IrSwap",
    "irSwapType": "IrFixedFloatingSwap",
    "version": 0, 
    "start": 2025.06.16,
    "maturity": 2028.06.16,
    "frequency": "Quarterly",
    "fixedRate": 0.018,
    "calendar": "CFET", 
    "fixedDayCountConvention": "Actual365",
    "floatingDayCountConvention": "Actual360",
    "payReceive": "Receive",
    "iborIndex": "SHIBOR_3M",
    "spread": 0.0001,
    "notional":["CNY", 1E8]
}

pricingDate = 2025.08.18

curve = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "version": 0,
    "referenceDate": pricingDate,
    "currency": "CNY",
    "curveName": "CNY_SHIBOR_3M",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",     
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates":[2025.08.21, 2025.08.27, 2025.09.03, 2025.09.10, 2025.09.22, 2025.10.20, 2025.11.20, 
             2026.02.24, 2026.05.20, 2026.08.20, 2027.02.22, 2027.08.20,2028.08.21],
    "values":[1.5113, 1.5402, 1.5660, 1.5574, 1.5556, 1.5655, 1.5703, 
              1.5934, 1.6040, 1.6020, 1.5928, 1.5842, 1.6068] / 100
}

// To calculate the floating rate for the first cash flow after the valuation date, historical data of the reference rate must be provided.
// Since the payment frequency of the SHIBOR_3M interest rate swap is quarterly, it is recommended to provide at least 70 trading days of historical SHIBOR_3M fixing data.
shibor3mHistCurve = {
    "mktDataType": "Curve",
    "curveType": "AssetPriceCurve",
    "version": 0,
    "referenceDate": 2022.05.15,
    "currency": "CNY",
    "dates":[2025.05.09, 2025.05.12, 2025.05.13, 2025.05.14, 2025.05.15, 2025.05.16, 2025.05.19, 2025.05.20, 2025.05.21, 2025.05.22,
             2025.05.23, 2025.05.26, 2025.05.27, 2025.05.28, 2025.05.29, 2025.05.30, 2025.06.03, 2025.06.04, 2025.06.05, 2025.06.06,
             2025.06.09, 2025.06.10, 2025.06.11, 2025.06.12, 2025.06.13, 2025.06.16, 2025.06.17, 2025.06.18, 2025.06.19, 2025.06.20,
             2025.06.23, 2025.06.24, 2025.06.25, 2025.06.26, 2025.06.27, 2025.06.30, 2025.07.01, 2025.07.02, 2025.07.03, 2025.07.04,
             2025.07.07, 2025.07.08, 2025.07.09, 2025.07.10, 2025.07.11, 2025.07.14, 2025.07.15, 2025.07.16, 2025.07.17, 2025.07.18,
             2025.07.21, 2025.07.22, 2025.07.23, 2025.07.24, 2025.07.25, 2025.07.28, 2025.07.29, 2025.07.30, 2025.07.31, 2025.08.01,
             2025.08.04, 2025.08.05, 2025.08.06, 2025.08.07, 2025.08.08, 2025.08.11, 2025.08.12, 2025.08.13, 2025.08.14, 2025.08.15
       ],
    "values":[1.6960, 1.6720, 1.6620, 1.6530, 1.6450, 1.6470, 1.6450, 1.6420, 1.6400, 1.6400, 
              1.6420, 1.6430, 1.6440, 1.6470, 1.6520, 1.6520, 1.6520, 1.6520, 1.6520, 1.6510, 
              1.6490, 1.6450, 1.6420, 1.6390, 1.6380, 1.6360, 1.6340, 1.6300, 1.6300, 1.6290, 
              1.6290, 1.6290, 1.6300, 1.6300, 1.6300, 1.6300, 1.6280, 1.6195, 1.6060, 1.5970, 
              1.5790, 1.5700, 1.5620, 1.5590, 1.5570, 1.5610, 1.5590, 1.5590, 1.5570, 1.5550, 
              1.5530, 1.5490, 1.5510, 1.5530, 1.5590, 1.5600, 1.5600, 1.5640, 1.5660, 1.5630, 
              1.5590, 1.5580, 1.5590, 1.5600, 1.5544, 1.5490, 1.5480, 1.5480, 1.5490, 1.5470  
               ]\100
}

instrument = parseInstrument(irs)
curve = parseMktData(curve)
discountCurve = curve
forwardCurve = curve
assetPriceCurve = parseMktData(shibor3mHistCurve)

// Calculate npv
npv = irFixedFloatingSwapPricer(instrument, pricingDate, discountCurve, forwardCurve, assetPriceCurve)
print(npv)

// Calculate npv, cash flow
setting = {
    "calcCashFlow": true
}
results = irFixedFloatingSwapPricer(instrument, pricingDate, discountCurve, forwardCurve, assetPriceCurve, setting)
print(results)
```

**Related functions:** [parseInstrument](../p/parseInstrument.md), [parseMktData](../p/parseMktData.md)

