# irDepositPricer {#irDepositPricer}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`irDepositPricer(instrument, pricingDate, discountCurve)`

## Details {#topic_o1x_ydr_ngc}

Prices the certificate of deposit.

**Return value**: A DOUBLE scalar.

## Arguments {#arguments}

**instrument** is an INSTRUMENT scalar of Deposit type indicating the deposit to be priced.

**pricingDate** is a DATE scalar specifying the pricing date.

**discountCurve** is a MKTDATA scalar of type IrYieldCurve representing the discount curve.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
deposit =  {
    "productType": "Cash",
    "assetType": "Deposit",
    "version": 0, 
    "start": 2025.05.15,
    "maturity": 2025.08.15,
    "rate": 0.02,
    "dayCountConvention": "Actual360",
    "notional":["CNY", 1E6],
    "payReceive": "Receive"
}
rate = deposit["rate"]
instrument = parseInstrument(deposit)
print(instrument)
pricingDate = 2025.06.10
curve_dict = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "version": 0,
    "referenceDate": pricingDate,
    "currency": "CNY",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",  //Continuous compounding
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates":[2025.07.25, 2030.09.25],
    "values":[0.015, 0.015]
}
discountCurve = parseMktData(curve_dict)
irDepositPricer(instrument,2025.06.10,discountCurve)
// output:1002388.613154108868911
```

**Related functions:** [parseInstrument](../p/parseInstrument.md), [parseMktData](../p/parseMktData.md)

