# integral {#integral}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`integral(func, start, end, [start2], [end2])`

## Arguments {#arguments}

**func** is a unary function.

**start** is a numeric scalar/vector indicating start value. Null means negative infinity.

**end** is a numeric scalar/vector indicating end value. Null means positive infinity.

**start2** is a numeric scalar/vector/unary function indicating the start value of the second dimension in double integral. Null means negative infinity.

**end2** is a numeric scalar/vector/unary function indicating the end value of the second dimension in double integral. Null means positive infinity.

If both *start* and *end* are vectors, they must be of the same length.

If one of *start* and *end* is a scalar and the other is a vector, the scalar is treated as a vector of idential values.

## Details {#details}

Return the integral of *func* from start to end.

If the result is infinity or if the calculation involves complex numbers, the result is NULL.

## Examples {#examples}

```
integral(abs, -10, 10);
// output: 100

integral(acos, [0.1, -0.10], [0.3, 0.10]);
// output: [0.273816,0.314159]

integral(acosh, [1, 2, 9, 9], 10);
// output: [19.982354,19.080489,2.941187,2.941187]

integral(pow{,3}, 5, 9);
// output: 1484

integral(abs, NULL, NULL);
// output: 00F

def f(x1,x2){
   fx=100*(x2-x1*2)+square(1-x1)
   return fx
}

integral(f,0,1,7,1)
// output: -1802

integral(f,[0,1,2,3],7,2,[0,1,2,3])
// output: [8255.333333, 8256, 7856.666667, 7061.333333]
```

