# in {#in}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`in(X, Y)`

## Arguments {#arguments}

**X** is a scalar/vector.

**Y** is a scalar, vector, dictionary, in-memory table with one column, keyed table, or indexed table.

## Details {#details}

If *Y* is a scalar:

-   If *Y* is of temporal types, check if each element in *X* is equal to *Y*;

-   If *Y* is a scalar of other data types, check if *X* and *Y* are equal.


If *Y* is a null value, return false.

If *Y* is a vector, check if each element of *X* is an element in *Y*.

If *Y* is a dictionary, check if each element of *X* is a key in the dictionary *Y*.

If *Y* is an in-memory table with one column, check if each element of *X* appears in the column of *Y*. Note the column cannot be of array vector form.

If *Y* is a keyed table or an indexed table, check if each element of *X* is a key of *Y*. The number of elements in *X* must equal the number of key columns of *Y*.

## Examples {#examples}

```
in(3 3 5 2, 2 3);
// output: [true,true,false,true]

x=dict(INT,DOUBLE);
x[1, 2, 3]=[4.5, 6.6, 3.2];
x;
/* output:
3->3.2
1->4.5
2->6.6
*/

in(1..6, x);
// output: [true,true,true,false,false,false]

t = table(1 3 5 7 9 as id)
2 3 in t
// output: [false,true]

kt = keyedTable(`name`id,1000:0,`name`id`age`department,[STRING,INT,INT,STRING])
insert into kt values(`Tom`Sam`Cindy`Emma`Nick, 1 2 3 4 5, 30 35 32 25 30, `IT`Finance`HR`HR`IT)
in((`Tom`Cindy, 1 3), kt);
// output: [true,true]

t1 = indexedTable(`sym`side, 10000:0, `sym`side`price`qty, [SYMBOL,CHAR,DOUBLE,INT])
insert into t1 values(`IBM`MSFT`GOOG, ['B','S','B'], 10.01 10.02 10.03, 10 10 20)
in((`IBM`MSFT, ['S','S']), t1);
// output: [false,true]
```

When *X* is a floating-point number and *Y* is an integer, *X* will be converted to the data type of *Y*.

```
in(10, NULL)
// output: false

in('a', 97)
// output: true

in(1, 1.1 1.2 1.3)
// output: false

in(float(1.1 2.2 3.3 4.4 5.5 6.6 7.7 8.8), 1..9)
// output: [true,true,true,true,true,true,true,true]
```

`in` can be used with `select` for range filtering.

```
select * from kt where name in [`Tom, `Cindy];
```

|name|id|age|department|
|----|---|---|----------|
|Tom|1|30|IT|
|Cindy|3|32|HR|

Related functions: [find](../f/find.md), [binsrch](../b/binsrch.md).

