# imin {#imin}

## Syntax {#syntax}

`imin(X)`

## Arguments {#arguments}

**X** is a vector/matrix.

## Details {#details}

If *X* is a vector, return the position of the minimum value in a vector or a matrix. If there are multiple identical minimum values, return the position of the first minimum value starting from the left. As with all aggregate functions, null values are not included in the calculation.

If *X* is a matrix, conduct the aforementioned calculation within each column of *X*. The result is a vector.

## Examples {#examples}

```
x = 1.2 2 NULL -1 6 -1
imin(x);
// output: 3

x = 5 3 1 6 4 1 $ 3:2
imin(x);
// output: [2,2]
```

```
m=matrix(1 3 2 4, 4 2 3 1);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|3|2|
|2|3|
|4|1|

```
imin(m);
// output: [0,3]
```

