# imax {#imax}

## Syntax {#syntax}

`imax(X)`

## Arguments {#arguments}

**X** is a vector/matrix.

## Details {#details}

If *X* is a vector, return the position of the element with the largest value in *X*. If there are multiple identical maximum values, return the position of the first maximum value starting from the left.

If *X* is a matrix, conduct the aforementioned calculation within each column of *X*. The result is a vector.

## Examples {#examples}

```
x = 1.2 2 NULL 6 -1 6;
imax(x);
// output: 3

x = 5 3 1 6 4 6 $ 3:2;
imax(x);
// output: (0,1)

x=array(int,0);
x;
// output: []

imax(x);
// output: -1
// for an empty vector, imax returns -1.

m=matrix(1 2 3, 6 5 4);
m;
```

|\#0|\#1|
|---|---|
|1|6|
|2|5|
|3|4|

```
imax(m);
// output: [2,0]
```

