# iif {#iif}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`iif(cond, trueResult, falseResult)`

## Arguments {#arguments}

**cond** is a Boolean scalar/vector/matrix. It can be an expression returning Boolean values.

**trueResult** and **falseResult** are scalars/vectors/tuples/matrices that have the same number of elements as *cond*. Both must have the same data type.

## Details {#details}

Performs an element-wise conditional operation, evaluating each element of the condition. Specifically, if cond\[i\] is true, it returns the i-th element of *trueResult*; otherwise, it returns the i-th element of *falseResult*. When cond\[i\] is a null value, it returns a null value.

**Note:**

This function first parses the arguments and then returns *trueResult* or *falseResult* based on the result of *cond*.

## Examples {#examples}

```
iif(true true true false false false, 1..6, 6..1);
// output: [1,2,3,3,2,1]

iif(1..6==3, 1, 2);
// output: [2,2,1,2,2,2]

x=9 6 8;
iif(x<=8, 10*x, 20*x-80);
// output: [100,60,80]

a = 1..10
iif(isNull(a.prev()), a.cut(1), a.prev().cut(1))
// output: (1,1,2,3,4,5,6,7,8,9)
```

Use function `iif` in a SQL statement:

```
t=table(1..5 as id, 11..15 as x);
t1=table(take(12,5) as a, take(14,5) as b);
t;
```

|id|x|
|---|---|
|1|11|
|2|12|
|3|13|
|4|14|
|5|15|

```
t1;
```

|a|b|
|---|---|
|12|14|
|12|14|
|12|14|
|12|14|
|12|14|

```
update t set x=iif(x<t1.a, t1.a, iif(x>t1.b,t1.b, x));
t;
```

|id|x|
|---|---|
|1|12|
|2|12|
|3|13|
|4|14|
|5|14|

```
a = NULL 1 -3 5
iif(a > 0, a, 0)
// output: [0, 1, 0, 5]

iif(nullCompare(>,a,0), a, 0)
// output: [ , 1, 0, 5]
```

```
m1=1..6$3:2
m2=6..1$3:2
iif(m1>m2, m1, m2);
```

|col1|col2|
|----|----|
|6|4|
|5|5|
|4|6|

