# hmac {#hmac}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`hmac(key, message, [digest='sha256'])`

## Arguments {#arguments}

**key** is a LITERAL scalar indicating the secret key.

**message**is a LITERAL scalar indicating the message to be encrypted.

**digest**\(optional\)is a STRING scalar indicating the hash algorithm for encryption, which can be "sha256" \(default\), "sha1", "sha224", "sha 384", "sha512", and "md5".

## Details {#details}

Generate and return a hash value using the HMAC \(Hash-based Message Authentication Code\) mechanism. The value is a STRING scalar generated based on the given secret key and message using the specified hash algorithm.

## Examples {#examples}

``` {#codeblock_lym_jwt_fcc}
hmac(key="myKey", message="myMessage", digest="sha256")
// output:'71e5f5ca5f64550ee4524909f7cead7b81d8674a657383aec1b003a8a3f05b04'

hmac(key="myKey", message="myMessage", digest="sha1")
// output:'5033197fa89dedf5088eed6100dfa5a0f67ef1ce'

hmac(key="myKey2", message="myMessage", digest="sha256")
// output:'40e2a700754cec30ace1e82abfe7fd233f8f6c299050cc21b0e0a4ea42428126'
```

