# histogram2d {#histogram2d}

## Syntax {#Syntax .section}

`histogram2d(X, Y, [bins=10], [range], [density], [weights])`

## Arguments {#Arguments .section}

**X** and **Y** are numeric vectors of the same length, indicating the x and y coordinates of the points to be histogrammed. null values are not allowed.

**bins** \(optional\) is a numeric scalar, vector or a tuple. The default value is 10. Null values are not allowed. It can be:

-   Scalar: The number of bins for two dimensions.
-   Vector: The bin edges for the two diemensions. The vector must be strictly increasing.
-   Tuple with two scalars: The number of bins for each dimension.
-   Tuple with two vectors: The bin edges for each dimension.
-   Tuple with a scalar and a vector: The scalar represents the number of bins and the vector represents the bin edges, for the corresponding dimension.

**range** \(optional\) is a tuple with two 2-length vectors, indicating the bin edges along each dimension \(if not specified explicitly in the *bins* parameters\). All values outside of this range will be considered outliers and not tallied in the histogram. The default value is null.

**density** \(optional\) is a Boolean scalar. If false \(default\), returns the number of samples in each bin. If true, returns the probability *density* function at the bin, i.e., `bin_count / sample_count / bin_area`.

**weights** \(optional\) is a numeric vector of the same length as *X/Y* for weighing each sample \(x\_i, y\_i\). The default value is null. Note that null values are not allowed in the vector. *weights* are normalized to 1 if *density* is true. Otherwise, the values of the returned histogram are equal to the sum of the *weights* belonging to the samples falling into each bin.

## Details {#Details .section}

Compute the bi-dimensional histogram of two data samples.

**Return values**: A dictionary with the following keys:

-   H: The bi-dimensional histogram of samples x and y. Values in x are histogrammed along the first dimension and values in y are histogrammed along the second dimension. It is a matrix in the shape of \(nx, ny\), where nx and ny are the number of bins at each dimension.
-   xedges: A vector of length \(nx+1\) indicating the bin edges along the first dimension.
-   yedges: A vector of length \(ny+1\) indicating the bin edges along the second dimension.

## Examples {#Examples .section}

Example 1. Set bin edges and *density*=false.

``` {#codeblock_ytw_flv_ddc}
x = [0.1, 0.2, 0.5, 0.7, 0.9]
y = [0.2, 0.4, 0.6, 0.8, 1.0]
bins = [[0, 0.3, 0.6, 1.0], [0, 0.5, 1.0]]
density = false
result = histogram2d(x, y, bins, ,density)

/* Output:
H->#0 #1
-- --
2  0 
0  1 
0  2 
xedges->[0,0.3,0.6,1]
yedges->[0,0.5,1]
*/
```

Example 2. Set bin number, edges, weights and *density*=false.

``` {#codeblock_snj_glv_ddc}
x = [0.2, 0.4, 0.6, 0.8, 1.0]
y = [0.3, 0.5, 0.7, 0.9, 1.1]
bins = [2, [0.3, 0.5, 1.1]]
weights = [1, 2, 3, 4, 5]
density = true
result = histogram2d(x, y, bins, ,density, weights)

/* Output:
H->#0 #1
-- --
1  5 
0  9 
xedges->[0.2,0.6,1]
yedges->[0.3,0.5,1.1]
*/
```

**Parent topic:**[Functions](../../Functions/category.md)

