# highLong {#highlong}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`highLong(X)`

## Arguments {#arguments}

**X** is a scalar/vector/table/pair/dictionary which must be 16-byte data type \(UUID, IPADDR, INT128, COMPLEX, and POINT are supported\).

## Details {#details}

It returns the high-order 8-byte long integer data of *X*.

## Examples {#examples}

``` {#codeblock_cl4_h5z_21c}
x =ipaddr("192.168.1.13")
x1 = highLong(x)
print(x1)
// output: 0
```

``` {#codeblock_lkv_h5z_21c}
x=1 2 3 4
y=4 3 2 1
points = point(x, y)
x1 = highLong(points)
// output: [4616189618054758400,4613937818241073152,4611686018427387904,4607182418800017408]
```

Related function: [lowLong](../l/lowlong.md)

