# hex {#hex}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`hex(X, [reverse=false])`

## Arguments {#arguments}

**X** is an integer scalar/vector.

**reverse** \(optional\) is a Boolean value indicating whether to reverse the order of the result. The default value is false.

## Details {#details}

Convert data of INTEGRAL, FLOAT,COMPLEX, and BINARY types to hexadecimal and return a string. For details, see [Data Types](../../Programming/DataTypesandStructures/DataTypes/DataTypes.dita).

## Examples {#examples}

``` {#codeblock_lj4_w2d_s1c}
hex(16 25)
// output: ["00000010","00000019"]

hex(16 25,true)
// output: ["10000000","19000000"]
```

``` {#codeblock_dmv_x2d_s1c}
hex(compress(1 2 3))
// output: ["00","05","ff","01","04","04","00","00","ff","ff","ff","ff","03","00","00","00","ff","ff","ff","ff","0d","00","00","80","c0","01","00","00","00","02","00","00","00","03","00","00","00"]
```

``` {#codeblock_e4b_25n_1bc}
hex(123.456 3.1415926)
// output: ["405edd2f1a9fbe77","400921fb4d12d84a"]
```

